/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.utils.NameUtils;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Booleantype;
import org.mule.devkit.model.studio.NestedElementType;
import org.mule.devkit.model.studio.StudioModel;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBElement;

public class NestedsBuilder extends BaseStudioXmlBuilder implements StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>> {
    public NestedsBuilder(Context ctx, Module module) {
        super(ctx, module);
    }

    @Override
    public List<JAXBElement<? extends AbstractElementType>> build() {
        List<JAXBElement<? extends AbstractElementType>> nesteds = new ArrayList<JAXBElement<? extends AbstractElementType>>();

        ComplexTypeParameterVisitor complexTypeParameterVisitor = new ComplexTypeParameterVisitor();
        module.accept(complexTypeParameterVisitor);

        for (Variable<?> complexTypeParameter : complexTypeParameterVisitor.getRegisteredComplexTypes()) {
            if (!complexTypeParameter.isRefOnly()) {
                nesteds.add(objectFactory.createNested(generateNestedForType(complexTypeParameter)));
            }
        }

        return nesteds;
    }

    private NestedElementType generateNestedForType(Variable<?> variable) {
        NestedElementType nestedElementType = new NestedElementType();

        nestedElementType.setLocalId(NameUtils.uncamel(variable.getName()));
        nestedElementType.setAbstract(false);
        nestedElementType.setCaption("");
        nestedElementType.setDescription("");
        nestedElementType.setXmlname(NameUtils.uncamel(variable.getName()));

        Booleantype refBoolean = new Booleantype();
        refBoolean.setDescription("Provide a reference to a bean or use an expression");
        refBoolean.setCaption("Reference or expression");
        refBoolean.setName("useReference");
        refBoolean.setFillLine(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupRadioBoolean(refBoolean));

        AttributeType stringAttributeType = generateRefAttribute(variable);
        stringAttributeType.setControlled("useReference");
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createNestedElementTypeString(stringAttributeType));

        Booleantype radio2 = new Booleantype();
        radio2.setDescription("Define this element's attributes");
        radio2.setCaption("Define attributes");
        radio2.setName("complex");
        radio2.setFillLine(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupRadioBoolean(radio2));

        for (Field<Type> field : variable.asType().getFields()) {
            // Ignore constants and static fields (DEVKIT-270)
            // This condifition should be in sync with SchemaBuilder skip(Field) method
            if(field.hasGetter() && field.hasSetter() && !field.shouldBeIgnored()) {
                JAXBElement<? extends AttributeType> jaxbElement = createJaxbElement(field);
                // No need (and no reason!) to annotate with @Optional inside complex types used as operation arguments
                if (jaxbElement == null) continue;  //TODO: This is just for the moment, check why can be a null jaxbElement
                jaxbElement.getValue().setRequired(false);
                jaxbElement.getValue().setControlled("complex");
                nestedElementType.getRegexpOrEncodingOrString().add(jaxbElement);
            }
        }

        return nestedElementType;
    }

    private AttributeType generateRefAttribute(Variable<?> variable) {
        AttributeType stringAttributeType = new AttributeType();
        stringAttributeType.setName("ref");
        stringAttributeType.setCaption(helper.getFormattedCaption(variable));
        stringAttributeType.setDescription("");
        return stringAttributeType;
    }
}
