/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.TransformerMethod;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.GlobalType;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GlobalTransformerTypeOperationsBuilder extends GlobalTypeBuilder {

    public GlobalTransformerTypeOperationsBuilder(Context context, Module module) {
        super(context, module);
    }

    protected List<AttributeCategory> getAttributeCategories() {
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_CAPTION));
        attributeCategory.setDescription(helper.formatDescription(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION));

        attributeCategory.getGroup().add(createGroupWithModeSwitch(getTransformerMethodsSorted()));

        List<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>();
        attributeCategories.add(attributeCategory);
        return attributeCategories;
    }

    private List<TransformerMethod> getTransformerMethodsSorted() {
        List<TransformerMethod> transformer = module.getTransformerMethods();
        Collections.sort(transformer, new MethodComparator());
        return transformer;
    }

    protected String getDescriptionBasedOnType() {
        return helper.formatDescription("Global transformer");
    }

    protected String getExtendsBasedOnType() {
        return MuleStudioEditorXmlGenerator.URI_PREFIX + module.getModuleName() + '/' + AbstractTransformerBuilder.ABSTRACT_TRANSFORMER_LOCAL_ID;
    }

    protected String getLocalIdBasedOnType() {
        return "global-transformer";
    }

    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(module);
    }

    protected String getNameDescriptionBasedOnType() {
        return "Identifies the transformer so that other elements can reference it.";
    }

    @Override
    protected String getImage() {
        return helper.getTransformerImage(module);
    }

    @Override
    protected String getIcon() {
        return helper.getTransformerIcon(module);
    }

    @Override
    protected Boolean isAbstract() {
        return false;
    }

    @Override
    public GlobalType build() {
        // DEVKIT-368
        GlobalType globalTransformer = super.build();
        globalTransformer.setVersions(buildVersionsString());
        return globalTransformer;
    }
}