/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.EndpointType;

import java.util.Collections;
import java.util.List;

public class EndpointTypeOperationsBuilder extends EndpointTypeBuilder {

    public EndpointTypeOperationsBuilder(Context context, Module module) {
        super(context, null, module);
    }

    public EndpointType build() {
        EndpointType endpoinTypeOperations = super.build();
        endpoinTypeOperations.setAbstract(false);
        endpoinTypeOperations.setInboundLocalName(null);

        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_CAPTION));
        attributeCategory.setDescription(helper.formatDescription(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION));

        attributeCategory.getGroup().add(createGroupWithNoOperationModeSwitchForSources(getSourceMethodsSorted()));

        endpoinTypeOperations.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategory);
        endpoinTypeOperations.setExtends(MuleStudioEditorXmlGenerator.URI_PREFIX + module.getModuleName() + '/' + helper.getGlobalRefId(module.getModuleName()));

        // DEVKIT-368
        endpoinTypeOperations.setVersions(buildVersionsString());

        return endpoinTypeOperations;
    }

    @Override
    protected void processMethodParameters(EndpointType endpoint) {
        // ignore
    }

    @Override
    protected String getDescription() {
        return helper.getFormattedDescription(module);
    }

    @Override
    protected String getCaption() {
        return helper.getFormattedCaption(module) + " (Streaming)";
    }

    @Override
    protected String getLocalId() {
        return "endpoint";
    }

    private List<SourceMethod> getSourceMethodsSorted() {
        List<SourceMethod> methods = module.getSourceMethods();
        Collections.sort(methods, new MethodComparator());
        return methods;
    }
}