/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.*;

public class CacheConfigNestedElementBuilder extends BaseStudioXmlBuilder {

    public static final String CACHE_CONFIG_ELEMENT = "cache-config";


    protected CacheConfigNestedElementBuilder(Context context, Module module) {
        super(context, module);
    }

    public NestedElementType build() {
        NestedElementType nestedElementType = new NestedElementType();

        nestedElementType.setLocalId(CACHE_CONFIG_ELEMENT);
        nestedElementType.setAbstract(true);
        nestedElementType.setCaption("");
        nestedElementType.setDescription("");

        Booleantype defaultCacheConfig = new Booleantype();
        defaultCacheConfig.setFillLine(Boolean.TRUE);
        defaultCacheConfig.setDescription("Use default connection cache configuration.");
        defaultCacheConfig.setCaption("Use default connection cache configuration");
        defaultCacheConfig.setName("defaultCacheConfig");
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupRadioBoolean(defaultCacheConfig));


        Booleantype customCacheConfig = new Booleantype();
        customCacheConfig.setFillLine(Boolean.TRUE);
        customCacheConfig.setDescription("Define connection cache configuration.");
        customCacheConfig.setCaption("Define connection cache configuration");
        customCacheConfig.setName("customCacheConfig");
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupRadioBoolean(customCacheConfig));


        IntegerType initialCapacity = new IntegerType();
        initialCapacity.setDefaultValue(-1);
        initialCapacity.setMin(-1);
        initialCapacity.setDescription("Sets the minimum total size for the internal hash tables.");
        initialCapacity.setCaption("Initial Capacity");
        initialCapacity.setName("initialCapacity");
        initialCapacity.setControlled("customCacheConfig");
        initialCapacity.setIndented(Boolean.TRUE);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(initialCapacity));

        LongType expireAfterAccess = new LongType();
        expireAfterAccess.setDescription("Specifies that each entry should be automatically removed from the cache once a fixed duration has elapsed after the entry's creation, the most recent replacement of its value, or its last access.");
        expireAfterAccess.setCaption("Expire After Access (ms)");
        expireAfterAccess.setName("expireAfterAccess");
        expireAfterAccess.setDefaultValue(-1);
        expireAfterAccess.setMin(-1);
        expireAfterAccess.setControlled("customCacheConfig");
        expireAfterAccess.setIndented(Boolean.TRUE);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(expireAfterAccess));

        LongType expireAfterWrite = new LongType();
        expireAfterWrite.setDescription("Specifies that each entry should be automatically removed from the cache once a fixed duration has elapsed after the entry's creation, or the most recent replacement of its value.");
        expireAfterWrite.setDefaultValue(-1);
        expireAfterWrite.setCaption("Expire After Write (ms)");
        expireAfterWrite.setFillLine(true);
        expireAfterWrite.setName("expireAfterWrite");
        expireAfterWrite.setMin(-1);
        expireAfterWrite.setControlled("customCacheConfig");
        expireAfterWrite.setIndented(Boolean.TRUE);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(expireAfterWrite));

        return nestedElementType;
    }
}