/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.List;
import java.util.Map;
import org.mule.api.annotations.ConnectivityTesting;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.MetaDataSwitch;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.GlobalTypeBuilder;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.EnumElement;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.MetaDataType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalCloudConnectorTypeBuilder
extends GlobalTypeBuilder {
    private boolean abstrac7;
    private String globalRefId;
    private List<Module> usedMetaDataCategoryModules;

    public GlobalCloudConnectorTypeBuilder(Context context, Module module, List<Module> usedMetaDataCategoryModules, boolean abstrac7, String globalRefId) {
        super(context, module);
        this.usedMetaDataCategoryModules = usedMetaDataCategoryModules;
        this.abstrac7 = abstrac7;
        this.globalRefId = globalRefId == null ? this.helper.getGlobalRefId(module.getModuleName()) : globalRefId;
    }

    @Override
    public GlobalType build() {
        GlobalType globalCloudConnector = super.build();
        boolean isOauth = this.module instanceof OAuthModule;
        ConnectivityTesting connectivityTesting = null;
        MetaDataSwitch metadata = null;
        if (this.module.getAnnotation(org.mule.api.annotations.Module.class) != null) {
            connectivityTesting = ((org.mule.api.annotations.Module)this.module.getAnnotation(org.mule.api.annotations.Module.class)).connectivityTesting();
            metadata = ((org.mule.api.annotations.Module)this.module.getAnnotation(org.mule.api.annotations.Module.class)).metaData();
        } else if (this.module.getAnnotation(Connector.class) != null) {
            if (MetaDataSwitch.OFF.equals((Object)((Connector)this.module.getAnnotation(Connector.class)).metaData())) {
                metadata = MetaDataSwitch.OFF;
            } else if (this.module.getMinMuleVersion().atLeastBase("3.4") && (!this.usedMetaDataCategoryModules.isEmpty() || this.module.getMetaDataRetrieverMethod() != null && this.module.getMetaDataKeyRetrieverMethod() != null)) {
                metadata = MetaDataSwitch.DYNAMIC;
            } else if (this.module.getMinMuleVersion().atLeastBase("3.4")) {
                metadata = MetaDataSwitch.ON;
            }
            connectivityTesting = ((Connector)this.module.getAnnotation(Connector.class)).connectivityTesting();
        }
        if (isOauth) {
            connectivityTesting = ConnectivityTesting.DISABLED;
            metadata = MetaDataSwitch.ON;
        }
        if (!this.module.getMinMuleVersion().atLeastBase("3.4")) {
            connectivityTesting = ConnectivityTesting.OFF;
        }
        this.setConnectivityTestingAttribute(globalCloudConnector, connectivityTesting);
        this.setMetaDataAttribute(globalCloudConnector, metadata);
        globalCloudConnector.setVersions(this.buildVersionsString());
        return globalCloudConnector;
    }

    protected void setMetaDataAttribute(GlobalType globalCloudConnector, MetaDataSwitch metadata) {
        if (this.module.getMinMuleVersion().atLeastBase("3.4") && metadata != null) {
            switch (metadata) {
                case ON: {
                    globalCloudConnector.setMetaData("static");
                    break;
                }
                case DYNAMIC: {
                    globalCloudConnector.setMetaData("dynamic");
                    break;
                }
                case OFF: {
                    globalCloudConnector.setMetaData(null);
                }
            }
        }
    }

    protected void setConnectivityTestingAttribute(GlobalType globalCloudConnector, ConnectivityTesting connectivityTesting) {
        globalCloudConnector.setConnectivityTesting(connectivityTesting != null ? connectivityTesting.toString().toLowerCase() : ConnectivityTesting.OFF.toString().toLowerCase());
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        Group group = new Group();
        group.setId(this.moduleName + "GenericProperties");
        group.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupName(this.createNameAttributeType()));
        group.setCaption(this.helper.formatCaption("Basic Settings"));
        return this.processConfigurableFields(group);
    }

    @Override
    protected void createMetaDataAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.isModuleWithMetadata()) {
            Group defaultGroup = groupsByName.get("General");
            if (defaultGroup == null) {
                defaultGroup = new Group();
                defaultGroup.setCaption(this.helper.formatCaption("General"));
                defaultGroup.setId(StringUtils.uncapitalize((String)"General"));
                groupsByName.put("General", defaultGroup);
                if (attributeCategoriesByName.get("General") == null) {
                    attributeCategoriesByName.put("General", new AttributeCategory());
                    attributeCategoriesByName.get("General").setCaption("General");
                    attributeCategoriesByName.get("General").getGroup().add(defaultGroup);
                } else {
                    attributeCategoriesByName.get("General").getGroup().add(defaultGroup);
                }
            }
            MetaDataType metaDataType = new MetaDataType();
            metaDataType.setName("useMetaData");
            metaDataType.setCaption("useMetaData");
            defaultGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)metaDataType));
        }
    }

    @Override
    protected void processConnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module instanceof ManagedConnectionModule) {
            ManagedConnectionModule managedConnectionModule = (ManagedConnectionModule)this.module;
            Group connectionAttributesGroup = new Group();
            connectionAttributesGroup.setCaption(this.helper.formatCaption("Connection"));
            connectionAttributesGroup.setId(StringUtils.uncapitalize((String)"Connection"));
            groupsByName.put("Connection", connectionAttributesGroup);
            List<AttributeType> connectionAttributes = this.getConnectionAttributes(managedConnectionModule);
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().addAll(this.helper.createJAXBElements(connectionAttributes));
            AttributeCategory defaultAttributeCategory = attributeCategoriesByName.get("General");
            defaultAttributeCategory.getGroup().add(connectionAttributesGroup);
        }
    }

    @Override
    protected void createPoolingProfileAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module instanceof ManagedConnectionModule) {
            AttributeCategory poolProfileTab = new AttributeCategory();
            poolProfileTab.setCaption("Pooling Profile");
            poolProfileTab.setDescription("Pooling profile options.");
            Group poolingProfileGroup = new Group();
            poolingProfileGroup.setCaption("Pooling Profile");
            poolingProfileGroup.setId("poolingProfile");
            NestedElementReference childElement = new NestedElementReference();
            childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "connection-pooling-profile");
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setInplace(Boolean.valueOf(true));
            childElement.setValuePersistence("org.mule.tooling.ui.modules.core.widgets.meta.PoolingProfileValuePersistence");
            poolingProfileGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(childElement));
            poolProfileTab.getGroup().add(poolingProfileGroup);
            attributeCategoriesByName.put("Pooling Profile", poolProfileTab);
        }
    }

    @Override
    protected void createCacheConfigAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module instanceof ManagedConnectionModule) {
            AttributeCategory cacheConfigTab = new AttributeCategory();
            cacheConfigTab.setCaption("Cache Configuration");
            cacheConfigTab.setDescription("Cache configuration options.");
            Group cacheConfigGroup = new Group();
            cacheConfigGroup.setCaption("Cache Configuration");
            cacheConfigGroup.setId("cacheConfig");
            NestedElementReference childElement = new NestedElementReference();
            childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "cache-config");
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setInplace(Boolean.valueOf(true));
            cacheConfigGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(childElement));
            cacheConfigTab.getGroup().add(cacheConfigGroup);
            attributeCategoriesByName.put("Cache Config", cacheConfigTab);
        }
    }

    @Override
    protected void createReconnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module instanceof ManagedConnectionModule) {
            AttributeCategory reconnectionTab = new AttributeCategory();
            reconnectionTab.setCaption("Reconnection");
            reconnectionTab.setDescription("Reconnection options.");
            Group strategiesGroup = new Group();
            strategiesGroup.setCaption("Strategies");
            strategiesGroup.setId("reconnectionStrategies");
            NestedElementReference childElement = new NestedElementReference();
            childElement.setName("http://www.mulesoft.org/schema/mule/core/reconnectionStrategyElement");
            childElement.setValuePersistence("org.mule.tooling.ui.modules.core.widgets.meta.HTTPTransactionValuePersistence");
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setInplace(Boolean.valueOf(true));
            strategiesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(childElement));
            childElement = new NestedElementReference();
            childElement.setName("http://www.mulesoft.org/schema/mule/core/abstractReconnectionStrategy");
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setAllowSubTypes(Boolean.valueOf(true));
            childElement.setVisibleInDialog(Boolean.valueOf(false));
            childElement.setAllowedSubTypes("http://www.mulesoft.org/schema/mule/core/reconnect,http://www.mulesoft.org/schema/mule/core/reconnect-custom-strategy,http://www.mulesoft.org/schema/mule/core/reconnect-forever");
            strategiesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(childElement));
            reconnectionTab.getGroup().add(strategiesGroup);
            attributeCategoriesByName.put("Reconnection", reconnectionTab);
        }
    }

    @Override
    protected void createOAuthConfig(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module instanceof OAuthModule) {
            AttributeCategory oauthAttributeCategory = new AttributeCategory();
            oauthAttributeCategory.setCaption(this.helper.formatCaption("OAuth"));
            oauthAttributeCategory.setDescription(this.helper.formatDescription("OAuth."));
            Group oauthCallbackConfigGroup = this.helper.createGroup("oauthCallbackConfigGroup", "OAuth callback config");
            oauthAttributeCategory.getGroup().add(oauthCallbackConfigGroup);
            NestedElementReference oauthCallbackConfigChildElement = new NestedElementReference();
            oauthCallbackConfigChildElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "oauth-callback-config");
            oauthCallbackConfigChildElement.setCaption("");
            oauthCallbackConfigChildElement.setDescription("");
            oauthCallbackConfigChildElement.setInplace(Boolean.valueOf(true));
            oauthCallbackConfigGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(oauthCallbackConfigChildElement));
            Group oauthStoreConfigGroup = this.helper.createGroup("oauthStoreConfigGroup", "OAuth object store config");
            oauthAttributeCategory.getGroup().add(oauthStoreConfigGroup);
            NestedElementReference oauthStoreConfigChildElement = new NestedElementReference();
            oauthStoreConfigChildElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "oauth-store-config");
            oauthStoreConfigChildElement.setCaption("");
            oauthStoreConfigChildElement.setDescription("");
            oauthStoreConfigChildElement.setInplace(Boolean.valueOf(true));
            oauthStoreConfigGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(oauthStoreConfigChildElement));
            attributeCategoriesByName.put("OAuth", oauthAttributeCategory);
            if (this.module.getMinMuleVersion().atLeast("3.5")) {
                Group defaultGroup = groupsByName.get("General");
                if (defaultGroup == null) {
                    defaultGroup = new Group();
                    defaultGroup.setCaption(this.helper.formatCaption("General"));
                    defaultGroup.setId(StringUtils.uncapitalize((String)"General"));
                    groupsByName.put("General", defaultGroup);
                    if (attributeCategoriesByName.get("General") == null) {
                        attributeCategoriesByName.put("General", new AttributeCategory());
                        attributeCategoriesByName.get("General").setCaption("General");
                        attributeCategoriesByName.get("General").getGroup().add(defaultGroup);
                    } else {
                        attributeCategoriesByName.get("General").getGroup().add(defaultGroup);
                    }
                }
                EnumType onNoTokenEnum = new EnumType();
                onNoTokenEnum.setCaption(this.helper.formatCaption("On No Token"));
                onNoTokenEnum.setDescription(this.helper.formatDescription("Action to take when no token is found"));
                onNoTokenEnum.setName("onNoToken");
                onNoTokenEnum.setXsdType("string");
                onNoTokenEnum.setAllowsCustom(Boolean.valueOf(false));
                onNoTokenEnum.setDefaultValue("EXCEPTION");
                EnumElement el1 = new EnumElement();
                el1.setValue("EXCEPTION");
                onNoTokenEnum.getOption().add(el1);
                EnumElement el2 = new EnumElement();
                el2.setValue("STOP_FLOW");
                onNoTokenEnum.getOption().add(el2);
                defaultGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)onNoTokenEnum));
            }
        }
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return this.helper.formatDescription("Global " + this.helper.getFormattedCaption(this.module) + " configuration information");
    }

    @Override
    protected String getExtendsBasedOnType() {
        return "http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.globalRefId;
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return this.module.getConfigElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.module);
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return this.helper.formatDescription("Give a name to this configuration so it can be later referenced by config-ref.");
    }

    @Override
    protected String getImage() {
        return this.helper.getConnectorImage(this.module);
    }

    @Override
    protected String getIcon() {
        return this.helper.getConnectorIcon(this.module);
    }

    @Override
    protected Boolean isAbstract() {
        return this.abstrac7;
    }

    @Override
    protected void setMetadataAttributes(Variable<?> variable, AttributeType attributeType) {
        if (this.isModuleWithMetadata() && !variable.isOptional() && !variable.hasDefaultValue()) {
            attributeType.setRequiredForDataSense(Boolean.TRUE);
        }
    }

    protected boolean isModuleWithMetadata() {
        return this.module.hasDynamicMetadata() || this.module.isConnector() && ((Connector)this.module.getAnnotation(Connector.class)).metaData().equals((Object)MetaDataSwitch.ON) && (!this.usedMetaDataCategoryModules.isEmpty() || this.module.getMetaDataRetrieverMethod() != null && this.module.getMetaDataKeyRetrieverMethod() != null);
    }
}

