/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.mule.common.MuleVersion;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.module.Module;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMuleStudioGenerator
implements Generator {
    private static final List<Product> CONSUMES = Arrays.asList(new Product[0]);
    private static final List<Product> PRODUCES = Arrays.asList(new Product[0]);
    private Context context;

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    protected String getFeatureId(Collection<Module> modules) {
        return (String)this.ctx().getProduct(Product.STUDIO_FEATURE_NAME);
    }

    protected String getPluginId(String symbolicName, Module module) {
        if (symbolicName != null) {
            return symbolicName + "." + module.getMinMuleVersion().toCompleteNumericVersion();
        }
        return null;
    }

    protected MuleVersion getMaxVersion(Collection<Module> modules) {
        MuleVersion maxVersion = null;
        for (Module module : modules) {
            if (maxVersion != null && !maxVersion.priorTo(module.getMinMuleVersion())) continue;
            maxVersion = module.getMinMuleVersion();
        }
        return maxVersion;
    }

    protected String getLabel(Collection<Module> modules, String defaultExtensionName) {
        MuleVersion maxVersion = this.getMaxVersion(modules);
        String extensionName = this.getExtensionNameForFeatureLabel(modules, defaultExtensionName);
        if (maxVersion != null) {
            String muleVersion = maxVersion.toString();
            return String.format("%s (Mule %s+)", extensionName, muleVersion);
        }
        return extensionName;
    }

    private String getExtensionNameForFeatureLabel(Collection<Module> modules, String defaultExtensionName) {
        String name = null;
        String type = null;
        boolean usingFriendlyName = true;
        for (Module module : modules) {
            if (name == null) {
                name = module.getFriendlyName();
                if (name == null || name.trim().toLowerCase().endsWith("connector") || name.trim().toLowerCase().endsWith("module")) continue;
                if (module.isConnector()) {
                    type = "Connector";
                    continue;
                }
                type = "Module";
                continue;
            }
            if (!name.equals(module.getFriendlyName())) {
                name = defaultExtensionName;
                usingFriendlyName = false;
                break;
            }
            if (!module.isModule() || !"Connector".equals(type)) continue;
            type = "Module";
        }
        if (name == null) {
            name = defaultExtensionName;
            usingFriendlyName = false;
        }
        if (usingFriendlyName) {
            return StringUtils.isBlank(type) ? name : name + " " + type;
        }
        return name;
    }
}

