/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioNamespaceGenerator;
import org.mule.devkit.generation.studio.MuleStudioManifestGenerator;
import org.mule.devkit.generation.studio.packaging.FutureFile;
import org.mule.devkit.generation.studio.packaging.JarArchiverWrapper;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.generation.studio.packaging.Path;
import org.mule.devkit.generation.studio.packaging.PathBuilder;
import org.mule.devkit.generation.studio.packaging.Placeholder;
import org.mule.devkit.generation.studio.packaging.SimplePath;
import org.mule.devkit.generation.utils.VersionUtils;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleStudioPluginGenerator
extends AbstractMuleStudioNamespaceGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.STUDIO_ACTIVATOR, Product.STUDIO_MANIFEST, Product.STUDIO_PLUGIN_XML, Product.STUDIO_EDITOR_XML, Product.STUDIO_ICONS);
    private static final List<Product> PRODUCES = Arrays.asList(Product.STUDIO_PLUGINS);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    private boolean isManifest(Path fileName) {
        return fileName.getFullPath().endsWith("MF");
    }

    private void archiveFile(JarArchiverWrapper archiver, String fileName) throws RuntimeException, ArchiverException {
        FutureFile muleZipFile = new FutureFile(Placeholder.ROOT_DIRECTORY, fileName);
        archiver.addFile(muleZipFile, fileName);
    }

    @Override
    public void generate(Module module) throws GenerationException {
        FutureFile studioPlugin = null;
        JarArchiverWrapper archiver = new JarArchiverWrapper();
        String muleAppName = this.ctx().getMavenInformation().getArtifactId() + "-" + this.ctx().getMavenInformation().getVersion();
        try {
            this.archiveFile(archiver, muleAppName + ".zip");
            this.archiveFile(archiver, muleAppName + ".jar");
            if ("community".equalsIgnoreCase(this.getCategory())) {
                this.archiveFile(archiver, muleAppName + "-sources.jar");
            }
        }
        catch (ArchiverException e) {
            throw new RuntimeException("Error while packaging Studio plugin", e);
        }
        for (Product product : CONSUMES) {
            Object oneOrMoreFileNames = this.ctx().getProduct(product, (Identifiable)module);
            ArrayList<Path> fileNames = new ArrayList<Path>();
            if (oneOrMoreFileNames instanceof List && ((List)oneOrMoreFileNames).get(0) instanceof ModuleRelativePathBuilder) {
                for (ModuleRelativePathBuilder relativePath : (Collection)oneOrMoreFileNames) {
                    fileNames.add(relativePath.build(module));
                }
            } else if (oneOrMoreFileNames instanceof PathBuilder) {
                fileNames.add(((PathBuilder)oneOrMoreFileNames).build(module));
            } else if (oneOrMoreFileNames instanceof GeneratedClass) {
                fileNames.add(new SimplePath((GeneratedClass)oneOrMoreFileNames));
            } else if (oneOrMoreFileNames instanceof MuleStudioManifestGenerator.EclipsePlugin) {
                MuleStudioManifestGenerator.EclipsePlugin eclipsePlugin = (MuleStudioManifestGenerator.EclipsePlugin)oneOrMoreFileNames;
                studioPlugin = new FutureFile(Placeholder.PLUGINS_DIRECTORY, eclipsePlugin.getSymbolicName() + "_" + VersionUtils.buildVersion((String)this.ctx().getMavenInformation().getVersion()) + ".jar");
                fileNames.add(eclipsePlugin.getPath().build(module));
            } else {
                throw new RuntimeException("Unsupported product instance: " + oneOrMoreFileNames + ", while looking up " + product.toString());
            }
            for (Path fileName : fileNames) {
                FutureFile file = new FutureFile(Placeholder.CLASSES_DIRECTORY, fileName.getFullPath());
                if (this.isManifest(fileName)) {
                    archiver.setManifest(file);
                    continue;
                }
                archiver.addFile(file, fileName.getRelativeToModulePath());
            }
        }
        if (studioPlugin == null) {
            throw new RuntimeException("Studio Plugin path was not set by the ManifestGenerator");
        }
        archiver.setDestFile(studioPlugin);
        this.ctx().registerProduct(Product.STUDIO_PLUGINS, (Identifiable)module, (Object)archiver);
    }

    private String getCategory() {
        return this.ctx().getMavenInformation().getCategory();
    }
}

