/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.packaging;

import org.mule.devkit.model.module.Module;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class ModuleRelativePathBuilder implements PathBuilder<Module> {
    private String path;

    public ModuleRelativePathBuilder(String path) {
        this.path = path;
    }

    @Override
    public ModuleRelatviePath build(Module module) {
        return new ModuleRelatviePath(module);
    }

    public class ModuleRelatviePath implements Path {
        private Module module;

        private ModuleRelatviePath(Module module) {
            this.module = module;
        }

        @Override
        public String getFullPath() {
            return backlashReplace(module.getModuleName() + "/" + path);
        }

        @Override
        public String getRelativeToModulePath() {
            return path;
        }

        private String backlashReplace(String myStr){
            final StringBuilder result = new StringBuilder();
            final StringCharacterIterator iterator = new StringCharacterIterator(myStr);
            char character =  iterator.current();
            while (character != CharacterIterator.DONE ){
                if (character == '\\') {
                    result.append("/");
                }
                else {
                    result.append(character);
                }
                character = iterator.next();
            }
            return result.toString();
        }
    }
}
