/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.studio.packaging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JarArchiverWrapper implements ArchiverPlan, Serializable {

    private FutureFile destFile;
    private FutureFile manifest;
    private List<Tuple<FutureFile, String>> files;
    private List<FutureFile> directoriesToAdd;
    private List<ArchiverPlan> children;

    public JarArchiverWrapper() {
        this.files = new ArrayList<Tuple<FutureFile, String>>();
        this.directoriesToAdd = new ArrayList<FutureFile>();
        this.children = new ArrayList<ArchiverPlan>();
    }

    public void setManifest(FutureFile f) {
        this.manifest = f;
    }

    public void addFile(FutureFile f, String dest) {
        this.files.add(new Tuple<FutureFile, String>(f, dest));
    }

    public void addFile(JarArchiverWrapper promiseJarArchiver) {
        this.children.add(promiseJarArchiver);
    }

    public void setDestFile(FutureFile f) {
        this.destFile = f;
    }

    @Override
    public FutureFile getManifest() {
        return manifest;
    }

    @Override
    public FutureFile getDestFile() {
        return destFile;
    }

    @Override
    public List<Tuple<FutureFile, String>> getFiles() {
        return files;
    }

    @Override
    public List<ArchiverPlan> getChildren() {
        return children;
    }

    @Override
    public List<FutureFile> getDirectoriesToAdd() {
        return directoriesToAdd;
    }

}
