/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.api.annotations.Category;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.NewType;
import org.mule.devkit.model.studio.PatternType;
import org.mule.devkit.model.studio.StudioModel;
import org.mule.util.StringUtils;

import java.util.HashSet;
import java.util.Set;

import javax.xml.bind.JAXBElement;

public class SimpleConfigRefBuilder extends BaseStudioXmlBuilder implements StudioModel.ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> {

    public static final String GLOBAL_REF_NAME = SchemaConstants.ATTRIBUTE_NAME_CONFIG_REF;
    private static final boolean CONFIG_REF_REQUIRED = true;

    private Set<String> configElementNames;

    public SimpleConfigRefBuilder(Context context, Module module) {
        super(context, module);
        this.configElementNames = new HashSet<String>();
    }

    @Override
    public void addRequiredType(String configElementName) {
        this.configElementNames.add(configElementName);
    }

    @Override
    public JAXBElement<PatternType> build() {
        NewType globalRef = new NewType();

        StringBuilder stringBuilder = new StringBuilder();
        if (configElementNames.size() > 1) {
            stringBuilder.append("$");
            for (String configElement : configElementNames) {
                stringBuilder.append(MuleStudioEditorXmlGenerator.URI_PREFIX).append(moduleName).append('/').append(configElement);
                stringBuilder.append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        } else if (configElementNames.size() == 1) {
            stringBuilder.append(MuleStudioEditorXmlGenerator.URI_PREFIX).append(moduleName).append('/').append(configElementNames.iterator().next());
        } else {
            throw new RuntimeException(String.format("Error: There are no required types for [%s] SimpleConfigRefBuilder.", moduleName));
        }
        globalRef.setRequiredType(stringBuilder.toString());

        //TODO config-ref should be api-ref in the near future
        globalRef.setName(GLOBAL_REF_NAME);
        globalRef.setCaption(helper.formatCaption("connector configuration"));
        globalRef.setDescription(helper.formatDescription("Specify which configuration to use for this invocation"));
        globalRef.setRequired(CONFIG_REF_REQUIRED);

        Group group = new Group();
        group.setId(helper.getGlobalRefId(moduleName));
        group.getRegexpOrEncodingOrModeSwitch().add(objectFactory.createGroupGlobalRef(globalRef));
        group.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.GROUP_DEFAULT_CAPTION));

        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_CAPTION));
        attributeCategory.setDescription(helper.formatDescription(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION));
        attributeCategory.getGroup().add(group);

        PatternType cloudConnector = new PatternType();
        cloudConnector.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategory);
        cloudConnector.setCaption(helper.formatCaption(helper.getGlobalRefId(moduleName)));
        cloudConnector.setLocalId(helper.getGlobalRefId(moduleName));
        cloudConnector.setDescription(helper.formatDescription("Interact with " + StringUtils.capitalize(moduleName)));
        cloudConnector.setAbstract(true);
        cloudConnector.setIcon(helper.getConnectorIcon(module));
        cloudConnector.setImage(helper.getConnectorImage(module));

        Category category = module.getAnnotation(Category.class);
        if (category != null && StringUtils.isNotBlank(category.name())) {
            cloudConnector.setCategory(category.name());
        }

        return objectFactory.createNamespaceTypeCloudConnector(cloudConnector);
    }
}