/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.studio.editor;

public enum MimeType {

    TEXT_PLAIN("text/plain"),
    TEXT_CSS("text/css"),
    TEXT_JAVASCRIPT("text/javascript"),
    TEXT_XML("text/xml"),
    TEXT_XHTML("text/xhtml"),
    TEXT_HTML("text/html"),
    IMAGE("image/jpeg"),
    IMAGE_GIF("image/gif"),
    IMAGE_PNG("image/png"),
    APPLICATION_JSON("application/json"),
    APPLICATION_PDF("application/pdf"),
    APPLICATION_X_COMPRESSED("application/x-compressed"),
    APPLICATION_ZIP("application/zip"),
    MULTIPART_X_ZIP("multipart/x-zip"),
    BINARY_OCTET_STREAM("binary/octet-stream");

    private String value;

    MimeType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }
}