/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.module.TransformerMethod;
import org.mule.devkit.model.visitor.ModelVisitor;

import java.util.HashSet;
import java.util.Set;

public class AbstractVisitor implements ModelVisitor {
    private Set<Identifiable> visited;

    public AbstractVisitor() {
        this.visited = new HashSet<Identifiable>();
    }

    @Override
    public void visit(EnumType enumType) {
        this.visited.add(enumType);
    }

    @Override
    public void visit(Method method) {
        this.visited.add(method);
    }

    @Override
    public void visit(Parameter parameter) {
        this.visited.add(parameter);
    }

    @Override
    public void visit(Type type) {
        this.visited.add(type);
    }

    @Override
    public void visit(Field field) {
        this.visited.add(field);
    }

    @Override
    public void visit(Module module) {
        this.visited.add(module);
    }

    @Override
    public void visit(ProcessorMethod processorMethod) {
        this.visited.add(processorMethod);
    }

    @Override
    public void visit(SourceMethod sourceMethod) {
        this.visited.add(sourceMethod);
    }

    @Override
    public void visit(TransformerMethod transformerMethod) {
        this.visited.add(transformerMethod);
    }

    @Override
    public boolean hasVisited(Identifiable identifiable) {
        return visited.contains(identifiable);
    }

    @Override
    public void visit(org.mule.devkit.model.Package pkg) {
        this.visited.add(pkg);
    }
}
