/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioNamespaceGenerator;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.generation.utils.VersionUtils;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.module.Module;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleStudioManifestGenerator
extends AbstractMuleStudioNamespaceGenerator {
    private static final String MANIFEST_FILE_NAME = "META-INF/MANIFEST.MF";
    private static final List<Product> CONSUMES = Arrays.asList(Product.STUDIO_ACTIVATOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.STUDIO_MANIFEST);
    private static final String STUDIO_CONTRIBUTION = "org.mule.tooling.ui.contribution";
    private EclipsePlugin eclipsePlugin;

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public void generate(Module module) throws GenerationException {
        this.eclipsePlugin = new EclipsePlugin();
        PrintStream printStream = null;
        ModuleRelativePathBuilder relativePath = new ModuleRelativePathBuilder(MANIFEST_FILE_NAME);
        try {
            OutputStream outputStream = this.ctx().getCodeModel().getCodeWriter().openBinary(null, relativePath.build(module).getFullPath());
            printStream = new PrintStream(outputStream);
            printStream.append(this.getManifestContents(module));
            printStream.flush();
        }
        catch (IOException e) {
            try {
                throw new GenerationException("Could not create MANIFEST for Studio plugin: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(printStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)printStream);
        this.eclipsePlugin.setPath(relativePath);
        this.ctx().registerProduct(Product.STUDIO_MANIFEST, (Identifiable)module, (Object)this.eclipsePlugin);
    }

    private String getManifestContents(Module module) {
        StringBuilder manfiestContentBuilder = new StringBuilder(100);
        manfiestContentBuilder.append("Manifest-Version: 1.0\n");
        manfiestContentBuilder.append("Bundle-ManifestVersion: 2\n");
        String bundleName = module.getFriendlyName();
        manfiestContentBuilder.append("Bundle-Name: ").append(bundleName).append("\n");
        String symbolicName = "org.mule.tooling.ui.contribution." + module.getModuleName();
        String pluginId = this.getPluginId(symbolicName, module);
        manfiestContentBuilder.append("Bundle-SymbolicName: ").append(pluginId).append(";singleton:=true\n");
        this.eclipsePlugin.setSymbolicName(pluginId);
        manfiestContentBuilder.append("Bundle-Version: ").append(VersionUtils.buildVersion((String)module.getModuleSchemaVersion())).append("\n");
        manfiestContentBuilder.append("Bundle-Activator: ").append(((GeneratedClass)this.ctx().getProduct(Product.STUDIO_ACTIVATOR, (Identifiable)module)).fullName()).append("\n");
        manfiestContentBuilder.append("Bundle-Vendor: ").append(module.getJavaDocTagContent("author")).append("\n");
        manfiestContentBuilder.append("Require-Bundle: org.eclipse.ui,\n");
        manfiestContentBuilder.append(" org.eclipse.core.runtime,\n");
        manfiestContentBuilder.append(" org.mule.tooling.core;bundle-version=\"1.0.0\"\n");
        manfiestContentBuilder.append("Bundle-RequiredExecutionEnvironment: JavaSE-1.6\n");
        manfiestContentBuilder.append("Bundle-ActivationPolicy: lazy\n");
        manfiestContentBuilder.append("Eclipse-BundleShape: dir\n");
        return manfiestContentBuilder.toString();
    }

    public class EclipsePlugin {
        private String symbolicName;
        private ModuleRelativePathBuilder path;

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public ModuleRelativePathBuilder getPath() {
            return this.path;
        }

        public void setSymbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
        }

        public void setPath(ModuleRelativePathBuilder path) {
            this.path = path;
        }
    }
}

