/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.packaging;

import sun.security.tools.JarSigner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SignComponent {
    private String keystorePath;
    private final String storepass;
    private final String keypass;
    private final String alias;
    private final String tsaUrl;

    public SignComponent(String keystorePath, String storepass, String keypass, String alias, String tsaUrl) {
        this.keystorePath = keystorePath;
        this.storepass = storepass;
        this.keypass = keypass;
        this.alias = alias;
        this.tsaUrl = tsaUrl;
    }

    private List<String> buildOptions(String path) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-keystore");
        options.add(keystorePath);

        if (storepass != null) {
            options.add("-storepass");
            options.add(storepass);
        }

        if (keypass != null) {
            options.add("-keypass");
            options.add(keypass);
        }

        if (tsaUrl != null) {
            options.add("-tsa");
            options.add(tsaUrl);
        }

        options.add("-verbose");
        options.add(path);
        options.add(alias);

        return options;
    }

    public void sign(File pluginOrFeature) {
        if (keystorePath != null && new File(keystorePath).exists()) {
            JarSigner jarsigner = new JarSigner();

            List<String> pluginOrFeatureOptions = buildOptions(pluginOrFeature.getPath());

            jarsigner.run(pluginOrFeatureOptions.toArray(new String[0]));
        }
    }
}
