/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.ModeElementType;
import org.mule.util.StringUtils;

import java.util.List;

/**
 * Extension of {@link org.mule.devkit.generation.studio.editor.PatternTypeOperationsBuilder}
 * to handle modules implementing OAuth. The purpose of this extension is to generate metadata for the
 * implicit authorize and unauthorize methods
 *
 * @author mariano.gonzalez@mulesoft.com
 */
public class OAuthPatternTypeOperationsBuilder extends PatternTypeOperationsBuilder {

    public OAuthPatternTypeOperationsBuilder(Context context, Module module, PatternTypes patternTypeToUse) {
        super(context, module, patternTypeToUse);
    }

    @Override
    protected List<ModeElementType> getModes(List<? extends Method> methods) {
        List<ModeElementType> modes = super.getModes(methods);

        ModeElementType mode = new ModeElementType();
        String methodName = "authorize";
        mode.setModeId(MuleStudioEditorXmlGenerator.URI_PREFIX + module.getModuleName() + '/' + NameUtils.uncamel(methodName));
        mode.setModeLabel(StringUtils.capitalize(methodName));
        modes.add(0, mode);

        mode = new ModeElementType();
        methodName = "unauthorize";
        mode.setModeId(MuleStudioEditorXmlGenerator.URI_PREFIX + module.getModuleName() + '/' + NameUtils.uncamel(methodName));
        mode.setModeLabel(StringUtils.capitalize(methodName));
        modes.add(1, mode);

        return modes;
    }

}
