/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.Group;

import java.util.ArrayList;
import java.util.List;

public class GlobalTransformerTypeBuilder extends GlobalTypeBuilder {

    public GlobalTransformerTypeBuilder(Context context, Method executableElement, Module module) {
        super(context, executableElement, module);
    }

    @Override
    public GlobalType build() {
        GlobalType globalTransformer = super.build();
        globalTransformer.setAbstract(true);
        return globalTransformer;
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_CAPTION));
        attributeCategory.setDescription(helper.formatDescription(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION));

        Group group = new Group();
        group.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.GROUP_DEFAULT_CAPTION));
        group.getRegexpOrEncodingOrModeSwitch().add(objectFactory.createGroupName(createNameAttributeType()));

        attributeCategory.getGroup().add(group);

        List<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>();
        attributeCategories.add(attributeCategory);
        return attributeCategories;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return helper.formatDescription(method.getJavaDocSummary());
    }

    @Override
    protected String getExtendsBasedOnType() {
        return MuleStudioEditorXmlGenerator.URI_PREFIX + module.getModuleName() + '/' + getLocalIdBasedOnType();
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return NameUtils.uncamel(method.getName());
    }

    @Override
    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(method);
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return "Identifies the transformer so that other elements can reference it. Required if the transformer is defined at the global level.";
    }

    @Override
    protected String getImage() {
        return helper.getTransformerImage(module);
    }

    @Override
    protected String getIcon() {
        return helper.getTransformerIcon(module);
    }

    @Override
    protected Boolean isAbstract() {
        return false;
    }
}