/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.studio;

import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.javadoc.JavaDocAnnotationVerifier;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;

public class MuleStudioAnnotationVerifier extends JavaDocAnnotationVerifier {

    @Override
    public boolean shouldVerify(Module module) {
        return !super.shouldVerify(module);
    }

    @Override
    public void verify(Module module) throws AnnotationVerificationException {
        try {
            super.verify(module);
        } catch (AnnotationVerificationException e) {
            throw new AnnotationVerificationException(module, "Cannot generate Mule Studio plugin if required javadoc comments are not present. " +
                    "If you want to skip the generation of the Mule Studio plugin use -Ddevkit.studio.package.skip=true. Error is: " + e.getMessage(), e);
        }
    }

    @Override
    protected boolean exampleDoesNotExist(Method method) throws AnnotationVerificationException {
        // do not check for example correctness
        return false;
    }
}