/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.studio;

import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.model.module.Module;

import java.util.HashSet;
import java.util.Set;

public abstract class AbstractMuleStudioNamespaceGenerator extends AbstractMuleStudioGenerator implements ModuleGenerator {

    private Set<String> visitedNamespaces = new HashSet<String>();

    @Override
    public boolean shouldGenerate(Module module) {
        if (!visitedNamespaces.contains(module.getXmlNamespace())) {
            visitedNamespaces.add(module.getXmlNamespace());
            return true;
        }
        return false;
    }

}
