/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.Booleantype;
import org.mule.devkit.model.studio.NestedElementType;
import org.mule.devkit.model.studio.StringAttributeType;
import org.mule.devkit.model.studio.StudioModel;

import javax.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;

public class OAuthConfigNestedElementsBuilder extends BaseStudioXmlBuilder implements StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>> {

    public static final String OAUTH_CALLBACK_CONFIG_ELEMENT = "oauth-callback-config";
    public static final String OAUTH_STORE_CONFIG_ELEMENT = "oauth-store-config";

    protected OAuthConfigNestedElementsBuilder(Context context, Module module) {
        super(context, module);
    }

    public List<JAXBElement<? extends AbstractElementType>> build() {
        NestedElementType nestedElementType = createCallbackConfigNestedElementType();
        NestedElementType storeConfigNestedElementType = createStoreConfigNestedElementType();

        List<JAXBElement<? extends AbstractElementType>> nesteds = new ArrayList<JAXBElement<? extends AbstractElementType>>(2);
        nesteds.add(objectFactory.createNested(nestedElementType));
        nesteds.add(objectFactory.createNested(storeConfigNestedElementType));
        return nesteds;
    }

    private NestedElementType createCallbackConfigNestedElementType() {
        NestedElementType nestedElementType = new NestedElementType();
        nestedElementType.setLocalId(OAUTH_CALLBACK_CONFIG_ELEMENT);
        nestedElementType.setAbstract(true);
        nestedElementType.setCaption("");
        nestedElementType.setDescription("");

        StringAttributeType domainAttribute = helper.createStringAttributeType("Domain", "The domain name to use when setting up the callback endpoint", SchemaConstants.DOMAIN_ATTRIBUTE_NAME);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(domainAttribute));

        StringAttributeType localPort = helper.createStringAttributeType("Local port", "The local port to use when setting up the callback endpoint", SchemaConstants.LOCAL_PORT_ATTRIBUTE_NAME);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(localPort));

        StringAttributeType remotePort = helper.createStringAttributeType("Remote port", "The remote port is the port used to build the external callback URL", SchemaConstants.REMOTE_PORT_ATTRIBUTE_NAME);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(remotePort));

        StringAttributeType path = helper.createStringAttributeType("Path", "The path to use when setting up the callback endpoint", SchemaConstants.PATH_ATTRIBUTE_NAME);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(path));

        Booleantype asyncAttribute = new Booleantype();
        asyncAttribute.setCaption(helper.formatCaption("Async"));
        asyncAttribute.setDescription(helper.formatDescription("Async"));
        asyncAttribute.setName(SchemaConstants.ASYNC_ATTRIBUTE_NAME);
        asyncAttribute.setDefaultValue(SchemaConstants.ASYNC_DEFAULT_VALUE);
        asyncAttribute.setFillLine(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupBoolean(asyncAttribute));
        return nestedElementType;
    }

    private NestedElementType createStoreConfigNestedElementType() {
        NestedElementType nestedElementType = new NestedElementType();
        nestedElementType.setLocalId(OAUTH_STORE_CONFIG_ELEMENT);
        nestedElementType.setAbstract(true);
        nestedElementType.setCaption("");
        nestedElementType.setDescription(SchemaConstants.OAUTH_STORE_CONFIG_ELEMENT_DESCRIPTION);

        StringAttributeType objectStoreRefAttribute = helper.createStringAttributeType("Object store reference", "Object store reference", SchemaConstants.OBJECT_STORE_REF_ATTRIBUTE_NAME);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(objectStoreRefAttribute));

        return nestedElementType;
    }
}