/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;

import java.util.List;

public abstract class GlobalTypeBuilder extends BaseStudioXmlBuilder {

    public GlobalTypeBuilder(Context context, Method executableElement, Module module) {
        super(context, executableElement, module);
    }

    public GlobalTypeBuilder(Context context, Module module) {
        super(context, module);
    }

    protected abstract List<AttributeCategory> getAttributeCategories();

    protected abstract String getDescriptionBasedOnType();

    protected abstract String getExtendsBasedOnType();

    protected abstract String getLocalIdBasedOnType();

    protected abstract String getNameDescriptionBasedOnType();

    protected abstract String getImage();

    protected abstract String getIcon();

    protected abstract Boolean isAbstract();

    public GlobalType build() {
        GlobalType globalType = new GlobalType();
        globalType.setImage(getImage());
        globalType.setIcon(getIcon());
        globalType.setCaption(getCaptionBasedOnType());
        globalType.setLocalId(getLocalIdBasedOnType());
        globalType.setExtends(getExtendsBasedOnType());
        globalType.setDescription(getDescriptionBasedOnType());
        globalType.setAbstract(isAbstract());

        globalType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().addAll(getAttributeCategories());

        return globalType;
    }

    protected AttributeType createNameAttributeType() {
        AttributeType name = new AttributeType();
        name.setName("name");
        name.setCaption(helper.formatCaption("Name"));
        name.setDescription(helper.formatDescription(getNameDescriptionBasedOnType()));
        name.setRequired(true);
        return name;
    }

    protected String getCaptionBasedOnType() {
        return BaseStudioXmlBuilder.GENERAL_GROUP_NAME;
    }
}