/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.api.annotations.Category;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.PatternType;
import org.mule.util.StringUtils;

import javax.xml.bind.JAXBElement;
import java.util.Collections;
import java.util.List;

public class PatternTypeOperationsBuilder extends BaseStudioXmlBuilder {

    private static final String ALIAS_ID_PREFIX = "org.mule.tooling.ui.modules.core.pattern.";
    private static final MethodComparator METHOD_COMPARATOR = new MethodComparator();
    private PatternTypes patternTypeToUse;

    public PatternTypeOperationsBuilder(Context context, Module module, PatternTypes patternTypeToUse) {
        super(context, module);
        if (!patternTypeToUse.equals(PatternTypes.CLOUD_CONNECTOR) && !patternTypeToUse.equals(PatternTypes.TRANSFORMER)) {
            throw new IllegalArgumentException("PatternType not supported: " + patternTypeToUse);
        }
        this.patternTypeToUse = patternTypeToUse;
    }

    public JAXBElement<PatternType> build() {

        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_CAPTION));
        attributeCategory.setDescription(helper.formatDescription(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION));
        attributeCategory.getGroup().add(createGroupWithModeSwitch(getMethods()));

        PatternType patternType = new PatternType();
        patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategory);
        patternType.setCaption(helper.getFormattedCaption(module));

        if (patternTypeToUse.equals(PatternTypes.CLOUD_CONNECTOR)) {
            patternType.setLocalId(module.getModuleName() + "-connector");
            patternType.setExtends(MuleStudioEditorXmlGenerator.URI_PREFIX + module.getModuleName() + '/' + helper.getGlobalRefId(module.getModuleName()));
        } else {
            patternType.setLocalId(module.getModuleName() + "-transformer");
        }
        patternType.setDescription(helper.getFormattedDescription(module));
        patternType.setAliasId(ALIAS_ID_PREFIX + module.getModuleName());
        patternType.setIcon(getIcon());
        patternType.setImage(getImage());

        // DEVIT-368
        patternType.setVersions(buildVersionsString());

        if (patternTypeToUse.equals(PatternTypes.CLOUD_CONNECTOR)) {
            Category category = module.getAnnotation(Category.class);
            if (category != null && StringUtils.isNotBlank(category.name())) {
                patternType.setCategory(category.name());
            }
            return objectFactory.createNamespaceTypeCloudConnector(patternType);
        } else {
            return objectFactory.createNamespaceTypeTransformer(patternType);
        }
    }

    private String getImage() {
        if (patternTypeToUse.equals(PatternTypes.TRANSFORMER)) {
            return helper.getTransformerImage(module);
        } else {
            return helper.getConnectorImage(module);
        }
    }

    private String getIcon() {
        if (patternTypeToUse.equals(PatternTypes.TRANSFORMER)) {
            return helper.getTransformerIcon(module);
        } else {
            return helper.getConnectorIcon(module);
        }
    }

    private List<? extends Method> getMethods() {
        List<? extends Method> methods;
        if (patternTypeToUse.equals(PatternTypes.CLOUD_CONNECTOR)) {
            methods = module.getProcessorMethods();
        } else {
            methods = module.getTransformerMethods();
        }
        Collections.sort(methods, METHOD_COMPARATOR);
        return methods;
    }
}