/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.Group;

import java.util.ArrayList;
import java.util.List;

public class GlobalEndpointTypeBuilder extends GlobalTypeBuilder {

    public GlobalEndpointTypeBuilder(Context context, Method executableElement, Module module) {
        super(context, executableElement, module);
    }

    @Override
    public GlobalType build() {
        GlobalType globalEndpoint = super.build();
        globalEndpoint.setAbstract(true);
        globalEndpoint.setDoNotInherit(getDoNotInherit());
        return globalEndpoint;
    }

    protected List<AttributeCategory> getAttributeCategories() {
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_CAPTION));
        attributeCategory.setDescription(helper.formatDescription(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION));

        Group group = new Group();
        group.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.GROUP_DEFAULT_CAPTION));
        group.setId(getIdBasedOnType());

        attributeCategory.getGroup().add(group);

        group.getRegexpOrEncodingOrModeSwitch().add(objectFactory.createGroupName(createNameAttributeType()));

        List<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>();
        attributeCategories.add(attributeCategory);
        return attributeCategories;
    }

    protected String getDescriptionBasedOnType() {
        return helper.formatDescription(method.getJavaDocSummary());
    }

    protected String getExtendsBasedOnType() {
        return MuleStudioEditorXmlGenerator.URI_PREFIX + module.getModuleName() + '/' + getLocalIdBasedOnType();
    }

    protected String getLocalIdBasedOnType() {
        return NameUtils.uncamel(method.getName());
    }

    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(method);
    }

    protected String getNameDescriptionBasedOnType() {
        return "Endpoint name";
    }

    protected String getDoNotInherit() {
        return SimpleConfigRefBuilder.GLOBAL_REF_NAME;
    }

    @Override
    protected String getImage() {
        return helper.getEndpointImage(module);
    }

    @Override
    protected String getIcon() {
        return helper.getEndpointIcon(module);
    }

    @Override
    protected Boolean isAbstract() {
        return false;
    }

    private String getIdBasedOnType() {
        return "abstractEndpointGeneric";
    }
}