/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.EndpointType;

import java.util.Collection;

public class EndpointTypeBuilder extends BaseStudioXmlBuilder {

    public EndpointTypeBuilder(Context context, Method executableElement, Module module) {
        super(context, executableElement, module);
    }

    public EndpointType build() {
        EndpointType endpointType = new EndpointType();
        endpointType.setLocalId(getLocalId());
        endpointType.setCaption(getCaption());
        endpointType.setIcon(helper.getEndpointIcon(module));
        endpointType.setImage(helper.getEndpointImage(module));
        endpointType.setDescription(getDescription());
        endpointType.setSupportsInbound(true);
        endpointType.setSupportsOutbound(false);
        endpointType.setInboundLocalName(getLocalId());
        endpointType.setAbstract(true);
        endpointType.setExtends(MuleStudioEditorXmlGenerator.URI_PREFIX + module.getModuleName() + '/' + helper.getGlobalRefId(module.getModuleName()));

        processMethodParameters(endpointType);

        return endpointType;
    }

    protected void processMethodParameters(EndpointType endpoint) {
        Collection<AttributeCategory> attributeCategories = processMethodParameters();
        endpoint.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().addAll(attributeCategories);
    }

    protected String getDescription() {
        return helper.formatDescription(method.getJavaDocSummary());
    }

    protected String getCaption() {
        return helper.getFormattedCaption(method);
    }

    protected String getLocalId() {
        return NameUtils.uncamel(method.getName());
    }
}