/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.studio;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.Product;

import java.util.Arrays;
import java.util.List;

public abstract class AbstractMuleStudioGenerator implements Generator {

    private final static List<Product> CONSUMES = Arrays.asList(new Product[]{});
    private final static List<Product> PRODUCES = Arrays.asList(new Product[]{});

    private Context context;

    @Override
    public Context ctx() {
        return context;
    }

    @Override
    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

}