/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.GlobalTypeBuilder;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.Group;

public class GlobalTransformerTypeBuilder
extends GlobalTypeBuilder {
    public GlobalTransformerTypeBuilder(Context context, Method executableElement, Module module) {
        super(context, executableElement, module);
    }

    @Override
    public GlobalType build() {
        GlobalType globalTransformer = super.build();
        globalTransformer.setAbstract(Boolean.valueOf(true));
        return globalTransformer;
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(this.helper.formatCaption("General"));
        attributeCategory.setDescription(this.helper.formatDescription("General"));
        Group group = new Group();
        group.setCaption(this.helper.formatCaption("Generic"));
        group.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupName(this.createNameAttributeType()));
        attributeCategory.getGroup().add(group);
        ArrayList<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>();
        attributeCategories.add(attributeCategory);
        return attributeCategories;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return this.helper.formatDescription(this.method.getJavaDocSummary());
    }

    @Override
    protected String getExtendsBasedOnType() {
        return "http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.getLocalIdBasedOnType();
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return NameUtils.uncamel((String)this.method.getName());
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.method);
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return "Identifies the transformer so that other elements can reference it. Required if the transformer is defined at the global level.";
    }

    @Override
    protected String getImage() {
        return this.helper.getTransformerImage(this.module);
    }

    @Override
    protected String getIcon() {
        return this.helper.getTransformerIcon(this.module);
    }

    @Override
    protected Boolean isAbstract() {
        return false;
    }
}

