/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.List;
import java.util.Map;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.GlobalTypeBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.util.StringUtils;

public class GlobalCloudConnectorTypeBuilder
extends GlobalTypeBuilder {
    private boolean abstrac7;
    private String globalRefId;

    public GlobalCloudConnectorTypeBuilder(Context context, Module module, boolean abstrac7, String globalRefId) {
        super(context, module);
        this.abstrac7 = abstrac7;
        this.globalRefId = globalRefId == null ? this.helper.getGlobalRefId(module.getModuleName()) : globalRefId;
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        Group group = new Group();
        group.setId(this.moduleName + "GenericProperties");
        group.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupName(this.createNameAttributeType()));
        group.setCaption(this.helper.formatCaption("Generic"));
        return this.processConfigurableFields(group);
    }

    @Override
    protected void processConnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module instanceof ManagedConnectionModule) {
            ManagedConnectionModule managedConnectionModule = (ManagedConnectionModule)this.module;
            Group connectionAttributesGroup = new Group();
            connectionAttributesGroup.setCaption(this.helper.formatCaption("Connection"));
            connectionAttributesGroup.setId(StringUtils.uncapitalize((String)"Connection"));
            groupsByName.put("Connection", connectionAttributesGroup);
            List<AttributeType> connectionAttributes = this.getConnectionAttributes(managedConnectionModule);
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().addAll(this.helper.createJAXBElements(connectionAttributes));
            AttributeCategory defaultAttributeCategory = attributeCategoriesByName.get("General");
            defaultAttributeCategory.getGroup().add(connectionAttributesGroup);
        }
    }

    @Override
    protected void createReconnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module instanceof ManagedConnectionModule) {
            AttributeCategory reconnectionTab = new AttributeCategory();
            reconnectionTab.setCaption("Reconnection");
            reconnectionTab.setDescription("Reconnection options.");
            Group strategiesGroup = new Group();
            strategiesGroup.setCaption("Strategies");
            strategiesGroup.setId("reconnectionStrategies");
            NestedElementReference childElement = new NestedElementReference();
            childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "reconnectionStrategyElement");
            childElement.setValuePersistence("org.mule.tooling.ui.modules.core.widgets.meta.HTTPTransactionValuePersistence");
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setInplace(Boolean.valueOf(true));
            strategiesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(childElement));
            reconnectionTab.getGroup().add(strategiesGroup);
            attributeCategoriesByName.put("Reconnection", reconnectionTab);
        }
    }

    @Override
    protected void createOAuthConfig(Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module instanceof OAuthModule) {
            AttributeCategory oauthAttributeCategory = new AttributeCategory();
            oauthAttributeCategory.setCaption(this.helper.formatCaption("OAuth"));
            oauthAttributeCategory.setDescription(this.helper.formatDescription("OAuth."));
            Group oauthCallbackConfigGroup = this.helper.createGroup("oauthCallbackConfigGroup", "OAuth callback config");
            oauthAttributeCategory.getGroup().add(oauthCallbackConfigGroup);
            NestedElementReference oauthCallbackConfigChildElement = new NestedElementReference();
            oauthCallbackConfigChildElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "oauth-callback-config");
            oauthCallbackConfigChildElement.setCaption("");
            oauthCallbackConfigChildElement.setDescription("");
            oauthCallbackConfigChildElement.setInplace(Boolean.valueOf(true));
            oauthCallbackConfigGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(oauthCallbackConfigChildElement));
            Group oauthStoreConfigGroup = this.helper.createGroup("oauthStoreConfigGroup", "OAuth object store config");
            oauthAttributeCategory.getGroup().add(oauthStoreConfigGroup);
            NestedElementReference oauthStoreConfigChildElement = new NestedElementReference();
            oauthStoreConfigChildElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + "/" + "oauth-store-config");
            oauthStoreConfigChildElement.setCaption("");
            oauthStoreConfigChildElement.setDescription("");
            oauthStoreConfigChildElement.setInplace(Boolean.valueOf(true));
            oauthStoreConfigGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupChildElement(oauthStoreConfigChildElement));
            attributeCategoriesByName.put("OAuth", oauthAttributeCategory);
        }
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return this.helper.formatDescription("Global " + this.helper.getFormattedCaption(this.module) + " configuration information");
    }

    @Override
    protected String getExtendsBasedOnType() {
        return "http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.globalRefId;
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return this.module.getConfigElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.module);
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return this.helper.formatDescription("Give a name to this configuration so it can be later referenced by config-ref.");
    }

    @Override
    protected String getImage() {
        return this.helper.getConnectorImage(this.module);
    }

    @Override
    protected String getIcon() {
        return this.helper.getConnectorIcon(this.module);
    }

    @Override
    protected Boolean isAbstract() {
        return this.abstrac7;
    }
}

