/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.HashSet;
import java.util.Set;
import org.mule.devkit.generation.studio.editor.AbstractVisitor;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;

public class ComplexTypeParameterVisitor
extends AbstractVisitor {
    private Set<Variable> registeredComplexTypes = new HashSet<Variable>();

    @Override
    public void visit(Parameter parameter) {
        super.visit(parameter);
        this.checkIfComplexType((Variable)parameter);
    }

    @Override
    public void visit(Field field) {
        super.visit(field);
        this.checkIfComplexType((Variable)field);
    }

    private void checkIfComplexType(Variable identifiable) {
        Type type = identifiable.asType();
        if (type != null && type.isComplexType() && !this.registeredComplexTypes.contains(identifiable)) {
            this.registeredComplexTypes.add(identifiable);
        }
    }

    public Set<Variable> getRegisteredComplexTypes() {
        return this.registeredComplexTypes;
    }
}

