/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import oauth.signpost.http.HttpRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.rest.HttpMethod;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.rest.AbstractRestClientGenerator;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.components.connection.HttpBasicAuthComponent;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.module.rest.RestCall;
import org.mule.devkit.model.module.rest.RestExceptionOn;
import org.mule.devkit.model.module.rest.RestField;
import org.mule.devkit.model.module.rest.RestModule;
import org.mule.devkit.model.module.rest.RestParameter;
import org.mule.devkit.utils.NameUtils;
import org.mule.registry.TypeBasedTransformerResolver;
import org.mule.security.oauth.OAuth1Manager;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.transformer.simple.ObjectToString;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.http.HttpMuleMessageFactory;

public class RestClientAdapterGenerator
extends AbstractRestClientGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.OAUTH_ADAPTER, Product.PROCESS_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.REST_CLIENT_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasRestCalls();
    }

    public void generate(Module module) {
        OAuthCapability oAuthCapability = null;
        if (module instanceof OAuthModule || OAuth2StrategyUtilsResolver.hasOAuth2Component((Module)module)) {
            oAuthCapability = OAuth2StrategyUtilsResolver.getOAuthCapability((Module)module);
        }
        TypeReference previous = this.getPrevious(module, oAuthCapability);
        GeneratedClass restClientAdapterClass = this.getRestClientAdapterClass(module, previous);
        GeneratedField responseTimeout = restClientAdapterClass.field(4, (Type)this.ctx().getCodeModel().INT, "responseTimeout");
        GeneratedField muleContext = restClientAdapterClass.field(4, (Type)this.ref(MuleContext.class), "muleContext");
        if (oAuthCapability != null) {
            GeneratedMethod constructor = restClientAdapterClass.constructor(1);
            if (oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V2)) {
                constructor.param((Type)this.ref(OAuth2Manager.class).narrow(this.ref(OAuth2Adapter.class)), "oauthManager");
            } else if (oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V10A)) {
                constructor.param((Type)this.ref(OAuth1Manager.class), "oauthManager");
            }
            constructor.body().directStatement("super(oauthManager);");
        }
        Object httpClient = module.getRestHttpClientField() == null ? restClientAdapterClass.field(516, (Type)this.ref(HttpClient.class), "httpClient") : ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)module.getRestHttpClientField().getName())));
        GeneratedField httpMuleMessageFactory = restClientAdapterClass.field(4, (Type)this.ref(HttpMuleMessageFactory.class), "httpMuleMessageFactory");
        this.generateGetMuleMessage(restClientAdapterClass, (GeneratedVariable)httpMuleMessageFactory);
        this.generateSetMuleContext(restClientAdapterClass, muleContext, previous, (GeneratedVariable)httpMuleMessageFactory);
        this.generateGetPayloadTransformerMethod(restClientAdapterClass, muleContext);
        this.generateInitialiseMethod(restClientAdapterClass, module, (GeneratedExpression)httpClient, responseTimeout, previous);
        restClientAdapterClass.setter(responseTimeout);
        GeneratedClass http3Request = null;
        if (oAuthCapability != null && oAuthCapability.getOAuthVersion() == OAuthVersion.V10A) {
            http3Request = this.generateHttp3RequestInnerClass(restClientAdapterClass);
        }
        this.generateRestCallImplementations((RestModule)module, (GeneratedExpression)httpClient, (GeneratedVariable)muleContext, restClientAdapterClass, http3Request, oAuthCapability);
        this.generateSetHttpBasicAuthHeader(module, restClientAdapterClass);
    }

    private void generateSetHttpBasicAuthHeader(Module module, GeneratedClass restClientAdapterClass) {
        if (module.manager().httpBasicAuthComponent().isPresent()) {
            HttpBasicAuthComponent httpBasicAuthComponent = (HttpBasicAuthComponent)module.manager().httpBasicAuthComponent().get();
            GeneratedMethod setBasicAuthHeaderMethod = restClientAdapterClass.method(4, (Type)this.ctx().getCodeModel().VOID, "setHttpBasicAuthHeader");
            GeneratedVariable methodParam = setBasicAuthHeaderMethod.param((Type)this.ref(org.apache.commons.httpclient.HttpMethod.class), "method");
            GeneratedInvocation getStrategyMethod = ExpressionFactory.invoke((String)NameUtils.buildGetter((String)((Field)module.getConnectionStrategy().get()).getName()));
            Type strategyClassType = this.ref(httpBasicAuthComponent.asTypeMirror());
            GeneratedBlock thenBlock = setBasicAuthHeaderMethod.body()._if(Op._instanceof((GeneratedExpression)getStrategyMethod, (Type)strategyClassType))._then();
            GeneratedVariable stg = thenBlock.decl(strategyClassType, "stg", (GeneratedExpression)ExpressionFactory.cast((Type)strategyClassType, (GeneratedExpression)getStrategyMethod));
            GeneratedInvocation stringConcatenation = stg.invoke(httpBasicAuthComponent.username().getGetter().getName()).invoke("concat").arg(":");
            if (httpBasicAuthComponent.password().isPresent()) {
                stringConcatenation = stringConcatenation.invoke("concat").arg((GeneratedExpression)stg.invoke(((Field)httpBasicAuthComponent.password().get()).getGetter().getName()));
            }
            GeneratedVariable notEncodedHeader = thenBlock.decl((Type)this.ref(String.class), "notEncodedHeader", (GeneratedExpression)stringConcatenation);
            GeneratedVariable encodedHeader = thenBlock.decl((Type)this.ref(String.class), "encodedHeader", (GeneratedExpression)ExpressionFactory.lit((String)httpBasicAuthComponent.prefix()).invoke("concat").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(String.class)).arg((GeneratedExpression)this.ref(Base64.class).staticInvoke("encodeBase64").arg((GeneratedExpression)notEncodedHeader.invoke("getBytes")))));
            thenBlock.add((Statement)methodParam.invoke("addRequestHeader").arg(httpBasicAuthComponent.headerName()).arg((GeneratedExpression)encodedHeader));
        }
    }

    private GeneratedClass generateHttp3RequestInnerClass(GeneratedClass restClientAdapterClass) {
        GeneratedClass http3Request = restClientAdapterClass._class("Http3Request")._implements(this.ref(HttpRequest.class));
        GeneratedField httpMethod = http3Request.field(4, (Type)this.ref(org.apache.commons.httpclient.HttpMethod.class), "httpMethod");
        GeneratedMethod constructor = http3Request.constructor(1);
        GeneratedVariable method = constructor.param((Type)this.ref(org.apache.commons.httpclient.HttpMethod.class), "httpMethod");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)httpMethod), (GeneratedExpression)method);
        GeneratedMethod getMethod = http3Request.method(1, (Type)this.ref(String.class), "getMethod");
        getMethod.body()._return((GeneratedExpression)httpMethod.invoke("getName"));
        GeneratedMethod getRequestUrl = http3Request.method(1, (Type)this.ref(String.class), "getRequestUrl");
        GeneratedTry getRequestUrlTry = getRequestUrl.body()._try();
        getRequestUrlTry.body()._return((GeneratedExpression)httpMethod.invoke("getURI").invoke("toString"));
        getRequestUrlTry._catch(this.ref(URIException.class)).param("e");
        getRequestUrl.body()._return(ExpressionFactory._null());
        GeneratedMethod setRequestUrl = http3Request.method(1, (Type)this.ctx().getCodeModel().VOID, "setRequestUrl");
        GeneratedVariable url = setRequestUrl.param((Type)this.ref(String.class), "url");
        GeneratedTry setRequestUrlTry = setRequestUrl.body()._try();
        setRequestUrlTry.body().add((Statement)httpMethod.invoke("setURI").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(URI.class)).arg((GeneratedExpression)url)));
        setRequestUrlTry._catch(this.ref(URIException.class)).param("e");
        GeneratedMethod getHeader = http3Request.method(1, (Type)this.ref(String.class), "getHeader");
        GeneratedVariable headerName = getHeader.param((Type)this.ref(String.class), "name");
        GeneratedVariable header = getHeader.body().decl((Type)this.ref(Header.class), "header", (GeneratedExpression)httpMethod.invoke("getRequestHeader").arg((GeneratedExpression)headerName));
        GeneratedConditional ifHeader = getHeader.body()._if(header.isNotNull());
        ifHeader._then()._return((GeneratedExpression)header.invoke("getValue"));
        getHeader.body()._return(ExpressionFactory._null());
        GeneratedMethod setHeader = http3Request.method(1, (Type)this.ctx().getCodeModel().VOID, "setHeader");
        headerName = setHeader.param((Type)this.ref(String.class), "name");
        GeneratedVariable headerValue = setHeader.param((Type)this.ref(String.class), "value");
        setHeader.body().add((Statement)httpMethod.invoke("setRequestHeader").arg((GeneratedExpression)headerName).arg((GeneratedExpression)headerValue));
        GeneratedMethod getAllHeaders = http3Request.method(1, (Type)this.ref(Map.class).narrow(new TypeReference[]{this.ref(String.class), this.ref(String.class)}), "getAllHeaders");
        GeneratedVariable origHeaders = getAllHeaders.body().decl((Type)this.ref(Header.class).array(), "origHeaders", (GeneratedExpression)httpMethod.invoke("getRequestHeaders"));
        GeneratedVariable headers = getAllHeaders.body().decl((Type)this.ref(Map.class).narrow(new TypeReference[]{this.ref(String.class), this.ref(String.class)}), "headers", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HashMap.class).narrow(new TypeReference[]{this.ref(String.class), this.ref(String.class)})));
        GeneratedForEach forEach = getAllHeaders.body().forEach((Type)this.ref(Header.class), "h", (GeneratedExpression)origHeaders);
        forEach.body().add((Statement)headers.invoke("put").arg((GeneratedExpression)forEach.var().invoke("getName")).arg((GeneratedExpression)forEach.var().invoke("getValue")));
        getAllHeaders.body()._return((GeneratedExpression)headers);
        GeneratedMethod getContentType = http3Request.method(1, (Type)this.ref(String.class), "getContentType");
        GeneratedVariable type = getContentType.body().decl((Type)this.ref(String.class), "type", ExpressionFactory._null());
        GeneratedConditional ifPostMethod = getContentType.body()._if(Op._instanceof((GeneratedExpression)httpMethod, (Type)this.ref(PostMethod.class)));
        ifPostMethod._then().assign((AssignmentTarget)type, (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(PostMethod.class), (GeneratedExpression)httpMethod).invoke("getRequestEntity").invoke("getContentType"));
        ifPostMethod._else().assign((AssignmentTarget)type, (GeneratedExpression)ExpressionFactory.invoke((String)"getHeader").arg(ExpressionFactory.lit((String)"Content-Type")));
        getContentType.body()._return((GeneratedExpression)type);
        GeneratedMethod getMessagePayload = http3Request.method(1, (Type)this.ref(InputStream.class), "getMessagePayload");
        getMessagePayload._throws(this.ref(IOException.class));
        ifPostMethod = getMessagePayload.body()._if(Op._instanceof((GeneratedExpression)httpMethod, (Type)this.ref(PostMethod.class)));
        GeneratedVariable out = ifPostMethod._then().decl((Type)this.ref(ByteArrayOutputStream.class), "out", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ByteArrayOutputStream.class)));
        ifPostMethod._then().add((Statement)ExpressionFactory.cast((Type)this.ref(PostMethod.class), (GeneratedExpression)httpMethod).invoke("getRequestEntity").invoke("writeRequest").arg((GeneratedExpression)out));
        ifPostMethod._then()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ByteArrayInputStream.class)).arg((GeneratedExpression)out.invoke("toByteArray")));
        getMessagePayload.body()._return(ExpressionFactory._null());
        GeneratedMethod unwrap = http3Request.method(1, (Type)this.ref(Object.class), "unwrap");
        unwrap.body()._return((GeneratedExpression)httpMethod);
        return http3Request;
    }

    private void generateInitialiseMethod(GeneratedClass restClientAdapterClass, Module module, GeneratedExpression httpClient, GeneratedField responseTimeout, TypeReference previous) {
        GeneratedMethod initialise = restClientAdapterClass.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        initialise.annotate(this.ref(Override.class));
        if (previous instanceof GeneratedClass && ((GeneratedClass)previous).implementsClass(Initialisable.class)) {
            initialise.body().add((Statement)ExpressionFactory._super().invoke("initialise"));
        }
        if (module.getRestHttpClientField() == null) {
            initialise.body().assign((AssignmentTarget)((GeneratedField)httpClient), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HttpClient.class)));
        } else {
            GeneratedConditional ifNullHttpClient = initialise.body()._if(httpClient.isNull());
            ifNullHttpClient._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(InitialisationException.class)).arg((GeneratedExpression)this.ref(CoreMessages.class).staticInvoke("createStaticMessage").arg("Http client cannot be null.")).arg(ExpressionFactory._this()));
        }
        initialise.body().add((Statement)httpClient.invoke("getParams").invoke("setParameter").arg("http.protocol.version").arg((GeneratedExpression)this.ref(HttpVersion.class).staticRef("HTTP_1_1")));
        initialise.body().add((Statement)httpClient.invoke("getParams").invoke("setParameter").arg("http.socket.timeout").arg((GeneratedExpression)responseTimeout));
        initialise.body().add((Statement)httpClient.invoke("getParams").invoke("setParameter").arg("http.protocol.content-charset").arg("UTF-8"));
        initialise.body().add((Statement)httpClient.invoke("getParams").invoke("setCookiePolicy").arg((GeneratedExpression)this.ref(CookiePolicy.class).staticRef("BROWSER_COMPATIBILITY")));
        initialise._throws(this.ref(InitialisationException.class));
    }

    private void generateGetMuleMessage(GeneratedClass restClientAdapterClass, GeneratedVariable httpMuleMessageFactory) {
        GeneratedMethod getMuleMessage = restClientAdapterClass.method(4, (Type)this.ref(MuleMessage.class), "getMuleMessage");
        GeneratedVariable method = getMuleMessage.param((Type)this.ref(org.apache.commons.httpclient.HttpMethod.class), "method");
        GeneratedVariable encoding = getMuleMessage.param((Type)this.ref(String.class), "encoding");
        GeneratedTry tryTransform = getMuleMessage.body()._try();
        GeneratedVariable muleMessage = tryTransform.body().decl((Type)this.ref(MuleMessage.class), "muleMessage", (GeneratedExpression)httpMuleMessageFactory.invoke("create").arg((GeneratedExpression)method).arg((GeneratedExpression)encoding));
        tryTransform.body().invoke((GeneratedExpression)muleMessage, "getPayloadAsString");
        tryTransform.body()._return((GeneratedExpression)muleMessage);
        GeneratedCatchBlock catchCreateMuleMessage = tryTransform._catch(this.ref(Exception.class));
        GeneratedVariable payloadTransformerException = catchCreateMuleMessage.param("e");
        catchCreateMuleMessage.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Couldn't transform http response to MuleMessage").arg((GeneratedExpression)payloadTransformerException));
    }

    private void generateGetPayloadTransformerMethod(GeneratedClass restClientAdapterClass, GeneratedField muleContext) {
        GeneratedMethod getPayloadTransformer = restClientAdapterClass.method(4, (Type)this.ref(Transformer.class), "getPayloadTransformer");
        GeneratedVariable inputDataType = getPayloadTransformer.param((Type)this.ref(DataType.class), "inputDataType");
        GeneratedVariable outputDataType = getPayloadTransformer.param((Type)this.ref(DataType.class), "outputDataType");
        GeneratedTry tryGetTransformer = getPayloadTransformer.body()._try();
        GeneratedVariable typeResolver = tryGetTransformer.body().decl((Type)this.ref(TransformerResolver.class), "typeBasedResolver", (GeneratedExpression)muleContext.invoke("getRegistry").invoke("lookupObject").arg(this.ref(TypeBasedTransformerResolver.class).dotclass()));
        GeneratedVariable typeTransformer = tryGetTransformer.body().decl((Type)this.ref(Transformer.class), "typeResolverTransformer", (GeneratedExpression)typeResolver.invoke("resolve").arg((GeneratedExpression)inputDataType).arg((GeneratedExpression)outputDataType));
        GeneratedConditional ifNoTypeTransformer = tryGetTransformer.body()._if(Op.cor((GeneratedExpression)typeTransformer.isNull(), (GeneratedExpression)Op._instanceof((GeneratedExpression)typeTransformer, (Type)this.ref(ObjectToString.class))));
        GeneratedVariable payloadTransformer = ifNoTypeTransformer._then().decl((Type)this.ref(Transformer.class), "transformer", (GeneratedExpression)muleContext.invoke("getRegistry").invoke("lookupTransformer").arg((GeneratedExpression)inputDataType).arg((GeneratedExpression)outputDataType));
        GeneratedConditional ifPayloadTransformer = ifNoTypeTransformer._then()._if(payloadTransformer.isNotNull());
        ifPayloadTransformer._then()._return((GeneratedExpression)payloadTransformer);
        tryGetTransformer.body()._return((GeneratedExpression)typeTransformer);
        GeneratedCatchBlock catchResolverException = tryGetTransformer._catch(this.ref(ResolverException.class));
        GeneratedVariable resolverException = catchResolverException.param("rese");
        catchResolverException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)resolverException.invoke("getMessage")).arg((GeneratedExpression)resolverException));
        GeneratedCatchBlock catchRegistrationException = tryGetTransformer._catch(this.ref(RegistrationException.class));
        GeneratedVariable registrationException = catchRegistrationException.param("re");
        catchRegistrationException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)registrationException.invoke("getMessage")).arg((GeneratedExpression)registrationException));
        GeneratedCatchBlock catchTransformerException = tryGetTransformer._catch(this.ref(TransformerException.class));
        GeneratedVariable transformerException = catchTransformerException.param("te");
        catchTransformerException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)transformerException.invoke("getMessage")).arg((GeneratedExpression)transformerException));
    }

    private void generateSetMuleContext(GeneratedClass restClientAdapterClass, GeneratedField muleContext, TypeReference previous, GeneratedVariable httpMuleMessageFactory) {
        GeneratedMethod setMuleContext = restClientAdapterClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setMuleContext");
        GeneratedVariable context = setMuleContext.param((Type)this.ref(MuleContext.class), "context");
        if (previous instanceof GeneratedClass && ((GeneratedClass)previous).implementsClass(MuleContextAware.class)) {
            setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("setMuleContext").arg((GeneratedExpression)context));
        }
        setMuleContext.body().assign((AssignmentTarget)muleContext, (GeneratedExpression)context);
        setMuleContext.body().assign((AssignmentTarget)httpMuleMessageFactory, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HttpMuleMessageFactory.class)).arg((GeneratedExpression)muleContext));
    }

    private void generateRestCallImplementations(RestModule module, GeneratedExpression httpClient, GeneratedVariable muleContext, GeneratedClass capabilitiesAdapter, GeneratedClass http3Request, OAuthCapability oAuthCapability) {
        HashMap<String, GeneratedVariable> variables = new HashMap<String, GeneratedVariable>();
        for (RestCall executableElement : module.getRestCalls()) {
            GeneratedMethod override = capabilitiesAdapter.method(1, this.ref(executableElement.getReturnType()), executableElement.getName());
            override._throws(this.ref(IOException.class));
            for (Parameter parameter : executableElement.getParameters()) {
                variables.put(parameter.getName(), override.param(this.ref(parameter.asTypeMirror()), parameter.getName()));
            }
            GeneratedVariable method = override.body().decl((Type)this.ref(org.apache.commons.httpclient.HttpMethod.class), "method", ExpressionFactory._null());
            this.generateMethodAssignment(override, method, executableElement);
            this.generateParametersCode(module, variables, executableElement, override, method, oAuthCapability);
            this.generateHttpClientRequestEntity(variables, executableElement, override, method);
            this.signOauth1((Module)module, executableElement, override, http3Request, method, oAuthCapability);
            this.generateHttpClientExecuteMethod(override, httpClient, method, executableElement);
            this.generateParseResponseCode((Module)module, variables, executableElement, override, method, muleContext);
        }
    }

    private void generateHttpClientRequestEntity(Map<String, GeneratedVariable> variables, RestCall executableElement, GeneratedMethod override, GeneratedVariable method) {
        RestParameter payloadParameter;
        if ((executableElement.getRestNoun() == HttpMethod.POST || executableElement.getRestNoun() == HttpMethod.PUT) && (payloadParameter = executableElement.getPayloadParameter()) != null) {
            if (executableElement.payloadIsBinary().booleanValue()) {
                if (payloadParameter.isContentChunked()) {
                    override.body().add((Statement)ExpressionFactory.cast((Type)this.ref(EntityEnclosingMethod.class), (GeneratedExpression)method).invoke("setContentChunked").arg(ExpressionFactory.TRUE));
                }
                GeneratedVariable payloadRequestEntity = override.body().decl((Type)this.ref(RequestEntity.class), "payloadRequestEntity", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(InputStreamRequestEntity.class)).arg((GeneratedExpression)variables.get(payloadParameter.getName())).arg(executableElement.getContentType()));
                override.body().add((Statement)ExpressionFactory.cast((Type)this.ref(EntityEnclosingMethod.class), (GeneratedExpression)method).invoke("setRequestEntity").arg((GeneratedExpression)payloadRequestEntity));
            } else if (!executableElement.getContentType().equals("*/*")) {
                GeneratedVariable inputDataType = override.body().decl((Type)this.ref(DataType.class), "inputDataType", (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("createFromObject").arg((GeneratedExpression)variables.get(payloadParameter.getName())));
                GeneratedVariable outputDataType = override.body().decl((Type)this.ref(DataType.class), "outputDataType", (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref(String.class).dotclass()).arg(executableElement.getContentType()));
                GeneratedVariable payloadTransformer = override.body().decl((Type)this.ref(Transformer.class), "payloadTransformer", (GeneratedExpression)ExpressionFactory.invoke((String)"getPayloadTransformer").arg((GeneratedExpression)inputDataType).arg((GeneratedExpression)outputDataType));
                GeneratedTry tryToTransform = override.body()._try();
                GeneratedVariable payloadRequestEntity = tryToTransform.body().decl((Type)this.ref(RequestEntity.class), "payloadRequestEntity", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringRequestEntity.class)).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)payloadTransformer.invoke("transform").arg((GeneratedExpression)variables.get(payloadParameter.getName())))).arg(executableElement.getContentType()).arg(ExpressionFactory.lit((String)"UTF-8")));
                tryToTransform.body().add((Statement)ExpressionFactory.cast((Type)this.ref(EntityEnclosingMethod.class), (GeneratedExpression)method).invoke("setRequestEntity").arg((GeneratedExpression)payloadRequestEntity));
                GeneratedCatchBlock catchTransformerException = tryToTransform._catch(this.ref(TransformerException.class));
                GeneratedVariable transformerException = catchTransformerException.param("te");
                catchTransformerException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)transformerException.invoke("getMessage")).arg((GeneratedExpression)transformerException));
            } else {
                GeneratedVariable payloadRequestEntity = override.body().decl((Type)this.ref(RequestEntity.class), "payloadRequestEntity", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringRequestEntity.class)).arg((GeneratedExpression)this.ref(String.class).staticInvoke("valueOf").arg((GeneratedExpression)variables.get(payloadParameter.getName()))));
                override.body().add((Statement)ExpressionFactory.cast((Type)this.ref(EntityEnclosingMethod.class), (GeneratedExpression)method).invoke("setRequestEntity").arg((GeneratedExpression)payloadRequestEntity));
            }
        }
    }

    private void generateHttpClientExecuteMethod(GeneratedMethod override, GeneratedExpression httpClient, GeneratedVariable method, RestCall executableElement) {
        if (executableElement.getTimeout() == null) {
            override.body().add((Statement)httpClient.invoke("executeMethod").arg((GeneratedExpression)method));
        } else {
            GeneratedTry tryExecuteMethod = override.body()._try();
            tryExecuteMethod.body().add((Statement)httpClient.invoke("getParams").invoke("setParameter").arg(ExpressionFactory.lit((String)"http.socket.timeout")).arg(ExpressionFactory.lit((int)executableElement.getTimeout().getTimeout())));
            tryExecuteMethod.body().add((Statement)httpClient.invoke("executeMethod").arg((GeneratedExpression)method));
            GeneratedCatchBlock catchExecuteMethod = tryExecuteMethod._catch(this.ref(SocketTimeoutException.class));
            GeneratedVariable socketTimeoutException = catchExecuteMethod.param("stoe");
            GeneratedInvocation exception = executableElement.getTimeout().getException() == null ? ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)) : ExpressionFactory._new((Type)this.ref(executableElement.getTimeout().getException().asTypeMirror()));
            catchExecuteMethod.body()._throw((GeneratedExpression)exception.arg(ExpressionFactory.lit((String)"Read timed out")).arg((GeneratedExpression)socketTimeoutException));
        }
    }

    private void generateParametersCode(RestModule module, Map<String, GeneratedVariable> variables, RestCall executableElement, GeneratedMethod override, GeneratedVariable method, OAuthCapability oAuthCapability) {
        GeneratedVariable uri = this.generateUriParametersCode(module, variables, executableElement, override, method);
        this.generateQueryParametersCode(module, variables, executableElement, override, method, uri, oAuthCapability);
        this.generateHeaderParametersCode(module, variables, executableElement, override, method);
        if (executableElement.getRestNoun() == HttpMethod.POST) {
            this.generatePostParametersCode(module, variables, executableElement, override, method);
        }
    }

    private GeneratedVariable generateUriParametersCode(RestModule module, Map<String, GeneratedVariable> variables, RestCall executableElement, GeneratedMethod override, GeneratedVariable method) {
        GeneratedVariable uri = override.body().decl((Type)this.ref(String.class), "uri", ExpressionFactory.lit((String)executableElement.getUri()));
        for (RestParameter parameter : executableElement.getUriParameters()) {
            this.addUriParameter(executableElement, override.body(), uri, (GeneratedExpression)variables.get(parameter.getName()), parameter.ignoreIfEmpty(), parameter.getUriName());
        }
        for (RestField field : module.getUriFields()) {
            this.addUriParameter(executableElement, override.body(), uri, (GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)field.getName()))), field.ignoreIfEmpty(), field.getUriName());
        }
        override.body().add((Statement)method.invoke("setURI").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(URI.class)).arg((GeneratedExpression)uri).arg(ExpressionFactory.FALSE)));
        return uri;
    }

    private void generateQueryParametersCode(RestModule module, Map<String, GeneratedVariable> variables, RestCall executableElement, GeneratedMethod override, GeneratedVariable method, GeneratedVariable uri, OAuthCapability oAuthCapability) {
        GeneratedVariable queryString = override.body().decl((Type)this.ref(StringBuilder.class), "queryString", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)).arg(Op.cond((GeneratedExpression)method.invoke("getQueryString").isNotNull(), (GeneratedExpression)method.invoke("getQueryString"), (GeneratedExpression)ExpressionFactory.lit((String)""))));
        for (RestParameter parameter : executableElement.getQueryParameters()) {
            this.addQueryParameter(override.body(), queryString, (GeneratedExpression)variables.get(parameter.getName()), parameter.ignoreIfEmpty(), parameter.getUriName(), parameter.getSeparatedBy());
        }
        for (RestField field : module.getQueryFields()) {
            this.addQueryParameter(override.body(), queryString, (GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)field.getName()))), field.ignoreIfEmpty(), field.getUriName(), field.getSeparatedBy());
        }
        this.addOauth2AccessToken((Module)module, executableElement, queryString, override, oAuthCapability);
        GeneratedConditional ifQueryString = override.body()._if(Op.cand((GeneratedExpression)queryString.invoke("length").gt(ExpressionFactory.lit((int)0)), (GeneratedExpression)queryString.invoke("charAt").arg(ExpressionFactory.lit((int)0)).eq(ExpressionFactory.lit((char)'&'))));
        ifQueryString._then().add((Statement)queryString.invoke("deleteCharAt").arg(ExpressionFactory.lit((int)0)));
        override.body().add((Statement)method.invoke("setQueryString").arg((GeneratedExpression)this.ref(URIUtil.class).staticInvoke("encodeQuery").arg((GeneratedExpression)queryString.invoke("toString"))));
    }

    private void generateHeaderParametersCode(RestModule module, Map<String, GeneratedVariable> variables, RestCall executableElement, GeneratedMethod override, GeneratedVariable method) {
        for (RestParameter parameter : executableElement.getHeaderParameters()) {
            this.addHeaderParameter(override.body(), method, (GeneratedExpression)variables.get(parameter.getName()), parameter.ignoreIfEmpty(), parameter.getUriName(), parameter.getSeparatedBy());
        }
        for (RestField field : module.getHeaderFields()) {
            this.addHeaderParameter(override.body(), method, (GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)field.getName()))), field.ignoreIfEmpty(), field.getUriName(), field.getSeparatedBy());
        }
        if (module.manager().httpBasicAuthComponent().isPresent()) {
            override.body().invoke("setHttpBasicAuthHeader").arg((GeneratedExpression)method);
        }
    }

    private void addOauth2AccessToken(Module module, RestCall executableElement, GeneratedVariable queryString, GeneratedMethod override, OAuthCapability oAuthCapability) {
        if (oAuthCapability != null && executableElement.isOAuthProtected() && oAuthCapability.getOAuthVersion() == OAuthVersion.V2) {
            Field accessToken = oAuthCapability.getAccessTokenField();
            override.body().add((Statement)queryString.invoke("append").arg("&").invoke("append").arg(ExpressionFactory.lit((String)"access_token")).invoke("append").arg("=").invoke("append").arg((GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)accessToken.getName())))));
        }
    }

    private void signOauth1(Module module, RestCall executableElement, GeneratedMethod override, GeneratedClass http3Request, GeneratedVariable method, OAuthCapability oAuthCapability) {
        if (oAuthCapability != null && executableElement.isOAuthProtected() && oAuthCapability.getOAuthVersion() == OAuthVersion.V10A) {
            GeneratedTry oauthTry = override.body()._try();
            oauthTry.body().add((Statement)ExpressionFactory._super().invoke("getConsumer").invoke("sign").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)http3Request).arg((GeneratedExpression)method)));
            GeneratedCatchBlock oauthCatch = oauthTry._catch(this.ref(Exception.class));
            GeneratedVariable oauthException = oauthCatch.param("oe");
            oauthCatch.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg(ExpressionFactory.lit((String)"Unable to add Oauth 1.0 information to request")).arg((GeneratedExpression)oauthException));
        }
    }

    private void generatePostParametersCode(RestModule module, Map<String, GeneratedVariable> variables, RestCall executableElement, GeneratedMethod override, GeneratedVariable method) {
        GeneratedVariable postParameters = override.body().decl((Type)this.ref(List.class).narrow(this.ref(NameValuePair.class)), "postParameters", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(this.ref(NameValuePair.class))));
        for (RestParameter parameter : executableElement.getPostParameters()) {
            this.addPostParameter(override.body(), postParameters, (GeneratedExpression)variables.get(parameter.getName()), parameter.ignoreIfEmpty(), parameter.getUriName());
        }
        for (RestField field : module.getPostFields()) {
            this.addPostParameter(override.body(), postParameters, (GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)field.getName()))), field.ignoreIfEmpty(), field.getUriName());
        }
        override.body().add((Statement)ExpressionFactory.cast((Type)this.ref(PostMethod.class), (GeneratedExpression)method).invoke("addParameters").arg((GeneratedExpression)postParameters.invoke("toArray").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(NameValuePair.class).array()))));
    }

    private void generateMethodAssignment(GeneratedMethod override, GeneratedVariable method, RestCall restCall) {
        if (restCall.getRestNoun() == HttpMethod.GET) {
            override.body().assign((AssignmentTarget)method, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(GetMethod.class)));
        } else if (restCall.getRestNoun() == HttpMethod.PUT) {
            override.body().assign((AssignmentTarget)method, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(PutMethod.class)));
        } else if (restCall.getRestNoun() == HttpMethod.DELETE) {
            override.body().assign((AssignmentTarget)method, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DeleteMethod.class)));
        } else if (restCall.getRestNoun() == HttpMethod.POST) {
            override.body().assign((AssignmentTarget)method, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(PostMethod.class)));
        } else if (restCall.getRestNoun() == HttpMethod.TRACE) {
            override.body().assign((AssignmentTarget)method, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(TraceMethod.class)));
        }
    }

    private void generateParseResponseCode(Module module, Map<String, GeneratedVariable> variables, RestCall executableElement, GeneratedMethod override, GeneratedVariable method, GeneratedVariable muleContext) {
        GeneratedVariable muleMessage = override.body().decl((Type)this.ref(MuleMessage.class), "muleMessage", (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleMessage").arg((GeneratedExpression)method).arg(ExpressionFactory.lit((String)"UTF-8")));
        this.generateCopyResponseHeadersToMuleEvent(variables, executableElement, override, method);
        this.generateExceptionOnBlock(executableElement, override, muleContext, muleMessage);
        if (this.ref(executableElement.getReturnType()) != this.ctx().getCodeModel().VOID) {
            this.generateTransformAndReturn(module, executableElement, override, muleMessage);
        }
    }

    private void generateCopyResponseHeadersToMuleEvent(Map<String, GeneratedVariable> variables, RestCall executableElement, GeneratedMethod override, GeneratedVariable method) {
        if (executableElement.getAnnotation(Inject.class) != null) {
            boolean hasInjectedMuleEvent = false;
            GeneratedVariable muleEventParameter = null;
            for (Parameter parameter : executableElement.getParameters()) {
                if (!parameter.asTypeMirror().toString().startsWith(MuleEvent.class.getName())) continue;
                hasInjectedMuleEvent = true;
                muleEventParameter = variables.get(parameter.getName());
            }
            if (hasInjectedMuleEvent) {
                GeneratedForEach generatedForEach = override.body().forEach((Type)this.ref(Header.class), "header", (GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)method.invoke("getResponseHeaders")));
                generatedForEach.body().invoke((GeneratedExpression)muleEventParameter.invoke("getMessage"), "setOutboundProperty").arg((GeneratedExpression)generatedForEach.var().invoke("getName")).arg((GeneratedExpression)generatedForEach.var().invoke("getValue"));
            }
        }
    }

    private void generateTransformAndReturn(Module moduleClass, RestCall executableElement, GeneratedMethod methodBody, GeneratedVariable muleMessage) {
        GeneratedVariable output = methodBody.body().decl((Type)this.ref(String.class), "output", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)muleMessage.invoke("getPayload")));
        GeneratedConditional shouldTransform = methodBody.body()._if(Op.cand((GeneratedExpression)output.isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)this.ref(executableElement.getReturnType()).dotclass().invoke("isAssignableFrom").arg(this.ref(String.class).dotclass()))));
        GeneratedVariable outputDataType = shouldTransform._then().decl((Type)this.ref(DataType.class), "payloadOutputDataType", ExpressionFactory._null());
        GeneratedTry tryToTransform = shouldTransform._then()._try();
        GeneratedInvocation getMethod = this.ref(moduleClass.asTypeMirror()).dotclass().invoke("getMethod").arg(executableElement.getName());
        for (Parameter parameter : executableElement.getParameters()) {
            getMethod.arg(this.ref(parameter.asTypeMirror()).dotclass());
        }
        GeneratedVariable method = tryToTransform.body().decl((Type)this.ref(Method.class), "reflectedMethod", (GeneratedExpression)getMethod);
        tryToTransform.body().assign((AssignmentTarget)outputDataType, (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("createFromReturnType").arg((GeneratedExpression)method));
        GeneratedVariable inputDataType = tryToTransform.body().decl((Type)this.ref(DataType.class), "payloadInputDataType", (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref(String.class).dotclass()).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)muleMessage.invoke("getOutboundProperty").arg(ExpressionFactory.lit((String)"Content-Type")))));
        GeneratedVariable payloadTransformer = tryToTransform.body().decl((Type)this.ref(Transformer.class), "transformer", (GeneratedExpression)ExpressionFactory.invoke((String)"getPayloadTransformer").arg((GeneratedExpression)inputDataType).arg((GeneratedExpression)outputDataType));
        tryToTransform.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(executableElement.getReturnType()).boxify(), (GeneratedExpression)payloadTransformer.invoke("transform").arg((GeneratedExpression)output)));
        GeneratedCatchBlock catchTransformerException = tryToTransform._catch(this.ref(TransformerException.class));
        GeneratedVariable transformerException = catchTransformerException.param("te");
        catchTransformerException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg(Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"Unable to transform output from String to "), (GeneratedExpression)outputDataType.invoke("toString"))).arg((GeneratedExpression)transformerException));
        GeneratedCatchBlock catchNoSuchMethodException = tryToTransform._catch(this.ref(NoSuchMethodException.class));
        GeneratedVariable noSuchMethodException = catchNoSuchMethodException.param("nsme");
        catchNoSuchMethodException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg(ExpressionFactory.lit((String)("Unable to find method named " + executableElement.getName()))).arg((GeneratedExpression)noSuchMethodException));
        shouldTransform._else()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(executableElement.getReturnType()).boxify(), (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(Object.class), (GeneratedExpression)output)));
    }

    private void generateExceptionOnBlock(RestCall executableElement, GeneratedMethod methodBody, GeneratedVariable muleContext, GeneratedVariable muleMessage) {
        if (executableElement.getExceptions() != null) {
            List exceptions = executableElement.getExceptions();
            GeneratedVariable expressionManager = methodBody.body().decl((Type)this.ref(ExpressionManager.class), "expressionManager", (GeneratedExpression)muleContext.invoke("getExpressionManager"));
            for (RestExceptionOn restExceptionOn : exceptions) {
                if (restExceptionOn.getExpression() == null || "".equals(restExceptionOn.getExpression())) continue;
                GeneratedConditional ifError = methodBody.body()._if((GeneratedExpression)expressionManager.invoke("evaluateBoolean").arg(restExceptionOn.getExpression()).arg((GeneratedExpression)muleMessage));
                GeneratedInvocation exception = restExceptionOn.getException() == null ? ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)) : ExpressionFactory._new((Type)this.ref(restExceptionOn.getException().asTypeMirror()));
                ifError._then()._throw((GeneratedExpression)exception.arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)muleMessage.invoke("getPayload"))));
            }
        }
    }

    private void addQueryParameter(GeneratedBlock body, GeneratedVariable queryString, GeneratedExpression variable, boolean ignoreIfEmpty, String uriName, String token) {
        GeneratedBlock bodyHolder = this.retrieveBlockWithNullValidations(body, variable, ignoreIfEmpty);
        GeneratedInvocation rvalue = this.ref(String.class).staticInvoke("valueOf").arg(variable);
        if (!StringUtils.isEmpty((String)token)) {
            rvalue = this.ref(StringUtils.class).staticInvoke("join").arg((GeneratedExpression)variable.invoke("toArray")).arg(token);
        }
        bodyHolder.add((Statement)queryString.invoke("append").arg("&").invoke("append").arg(uriName).invoke("append").arg("=").invoke("append").arg((GeneratedExpression)rvalue));
    }

    private void addHeaderParameter(GeneratedBlock body, GeneratedVariable method, GeneratedExpression variable, boolean ignoreIfEmpty, String uriName, String token) {
        GeneratedBlock bodyHolder = this.retrieveBlockWithNullValidations(body, variable, ignoreIfEmpty);
        GeneratedInvocation rvalue = this.ref(String.class).staticInvoke("valueOf").arg(variable);
        if (!StringUtils.isEmpty((String)token)) {
            rvalue = this.ref(StringUtils.class).staticInvoke("join").arg((GeneratedExpression)variable.invoke("toArray")).arg(token);
        }
        bodyHolder.add((Statement)method.invoke("addRequestHeader").arg(uriName).arg((GeneratedExpression)rvalue));
    }

    private void addPostParameter(GeneratedBlock body, GeneratedVariable queryString, GeneratedExpression variable, boolean ignoreIfEmpty, String uriName) {
        GeneratedBlock bodyHolder = this.retrieveBlockWithNullValidations(body, variable, ignoreIfEmpty);
        GeneratedInvocation rvalue = this.ref(String.class).staticInvoke("valueOf").arg(variable);
        bodyHolder.add((Statement)queryString.invoke("add").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(NameValuePair.class)).arg(uriName).arg((GeneratedExpression)rvalue)));
    }

    private void addUriParameter(RestCall executableElement, GeneratedBlock body, GeneratedVariable uri, GeneratedExpression variable, boolean ignoreIfEmpty, String uriName) {
        if (executableElement.getUri().contains("{" + uriName + "}")) {
            if (ignoreIfEmpty) {
                GeneratedConditional ifTestingAgainstNull = this.retrieveIfWithNullValidations(body, variable);
                ifTestingAgainstNull._then().assign((AssignmentTarget)uri, (GeneratedExpression)uri.invoke("replace").arg("{" + uriName + "}").arg((GeneratedExpression)this.ref(String.class).staticInvoke("valueOf").arg(variable)));
                ifTestingAgainstNull._else().assign((AssignmentTarget)uri, (GeneratedExpression)uri.invoke("replace").arg("{" + uriName + "}").arg(ExpressionFactory.lit((String)"")));
            } else {
                body.assign((AssignmentTarget)uri, (GeneratedExpression)uri.invoke("replace").arg("{" + uriName + "}").arg((GeneratedExpression)this.ref(String.class).staticInvoke("valueOf").arg(variable)));
            }
        }
    }

    private GeneratedConditional retrieveIfWithNullValidations(GeneratedBlock body, GeneratedExpression variable) {
        return body._if(Op.cand((GeneratedExpression)variable.isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)this.ref(StringUtils.class).staticInvoke("isEmpty").arg((GeneratedExpression)this.ref(String.class).staticInvoke("valueOf").arg(variable)))));
    }

    private GeneratedBlock retrieveBlockWithNullValidations(GeneratedBlock body, GeneratedExpression variable, boolean ignoreIfEmpty) {
        GeneratedBlock bodyHolder = body;
        if (ignoreIfEmpty) {
            bodyHolder = this.retrieveIfWithNullValidations(body, variable)._then();
        }
        return bodyHolder;
    }

    private GeneratedClass getRestClientAdapterClass(Module module, TypeReference previous) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        GeneratedClass clazz = pkg._class(module.getClassName() + "RestClientAdapter", previous);
        clazz._implements(this.ref(Initialisable.class));
        clazz._implements(this.ref(Disposable.class));
        clazz._implements(this.ref(MuleContextAware.class));
        this.ctx().registerProduct(Product.REST_CLIENT_ADAPTER, (Identifiable)module, (Object)clazz);
        return clazz;
    }

    private TypeReference getPrevious(Module module, OAuthCapability oAuthCapability) {
        GeneratedClass previous = oAuthCapability != null ? ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass() : ((GeneratedClass)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)module)).topLevelClass();
        if (previous == null) {
            previous = (TypeReference)this.ref(module.asTypeMirror());
        }
        return previous;
    }
}

