/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.rest;

import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.mule.api.annotations.rest.BinaryParam;
import org.mule.api.annotations.rest.HttpMethod;
import org.mule.api.annotations.rest.RestHeaderParam;
import org.mule.api.annotations.rest.RestPostParam;
import org.mule.api.annotations.rest.RestQueryParam;
import org.mule.api.annotations.rest.RestUriParam;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.rest.RestCall;
import org.mule.devkit.model.module.rest.RestExceptionOn;
import org.mule.devkit.model.module.rest.RestField;
import org.mule.devkit.model.module.rest.RestModule;
import org.mule.devkit.model.module.rest.RestParameter;

public class RestClientAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasRestCalls();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        for (RestCall method : module.getRestCalls()) {
            if (!method.isAbstract()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.RESTCALL_METHOD_MUST_BE_ABSTRACT, new Object[0]);
            }
            if (method.getThrownTypes().size() != 1) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.RESTCALL_MUST_THROW_IOEXCEPTION, new Object[0]);
            }
            if (method.getExceptions() != null) {
                for (RestExceptionOn restExceptionOn : method.getExceptions()) {
                    if (restExceptionOn.getExpression() != null && !"".equals(restExceptionOn.getExpression())) continue;
                    gatherer.error((Identifiable)method, (DevkitNotification)Message.RESTEXCEPTIONON_MISSING_EXPRESSION, new Object[0]);
                }
            }
            int nonAnnotatedParameterCount = 0;
            int binaryAnnotatedParameterCount = 0;
            for (Parameter parameter : method.getParameters()) {
                if (!(parameter.hasAnnotation(RestUriParam.class) || parameter.hasAnnotation(RestHeaderParam.class) || parameter.hasAnnotation(RestQueryParam.class) || parameter.hasAnnotation(RestPostParam.class))) {
                    ++nonAnnotatedParameterCount;
                }
                if (!parameter.hasAnnotation(BinaryParam.class)) continue;
                ++binaryAnnotatedParameterCount;
            }
            int postParameter = method.getPostParameters().size();
            if (nonAnnotatedParameterCount > 1) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.MULTIPLE_PARAMETERS_SET_AS_PAYLOAD, new Object[0]);
            }
            if (nonAnnotatedParameterCount == 1 && postParameter > 0) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.POST_METHOD_DOES_NOT_SUPPORT_UNANNOTATED_PARAMS_AND_PAYLOAD, new Object[0]);
            }
            if (method.getRestNoun() != HttpMethod.POST && postParameter > 0) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.RESTPOSTPARAM_CAN_ONLY_BE_USED_ON_POST_METHODS, new Object[0]);
            }
            if (binaryAnnotatedParameterCount <= 0) continue;
            if (binaryAnnotatedParameterCount > 1) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.BINARYPARAM_MORE_THAN_ONE, new Object[0]);
            }
            if (method.payloadIsBinary().booleanValue()) {
                RestParameter payloadParameter = method.getPayloadParameter();
                if (!payloadParameter.asType().inheritsFrom(InputStream.class)) {
                    gatherer.error((Identifiable)method, (DevkitNotification)Message.BINARYPARAM_PARAMETER_MUST_IMPLEMENT_INPUTSTREAM, new Object[0]);
                }
                if (method.getRestNoun() == HttpMethod.POST) continue;
                gatherer.error((Identifiable)method, (DevkitNotification)Message.BINARYPARAM_CAN_ONLY_BE_USED_ON_POST_METHODS, new Object[0]);
                continue;
            }
            gatherer.error((Identifiable)method, (DevkitNotification)Message.BINARYPARAM_ONLY_SUPPORTS_PAYLOAD, new Object[0]);
        }
        for (RestField field : ((RestModule)module).getUriFields()) {
            if (field.hasGetter()) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.RESTURIPARAM_MISSING_GETTER, new Object[]{field.getName()});
        }
        for (RestField field : ((RestModule)module).getQueryFields()) {
            if (field.hasGetter()) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.RESTQUERYPARAM_MISSING_GETTER, new Object[]{field.getName()});
        }
        for (RestField field : ((RestModule)module).getHeaderFields()) {
            if (field.hasGetter()) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.RESTHEADERPARAM_MISSING_GETTER, new Object[]{field.getName()});
        }
        for (RestField field : ((RestModule)module).getPostFields()) {
            if (field.hasGetter()) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.RESTPOSTPARAM_MISSING_GETTER, new Object[]{field.getName()});
        }
        Field httpClientField = module.getRestHttpClientField();
        if (httpClientField != null && !((Object)httpClientField.asTypeMirror()).toString().equals(HttpClient.class.getName())) {
            gatherer.error((Identifiable)httpClientField, (DevkitNotification)Message.RESTHTTPCLIENT_INCORRECT_TYPE, new Object[]{HttpClient.class.getName()});
        }
        if (httpClientField != null && !httpClientField.hasGetter()) {
            gatherer.error((Identifiable)httpClientField, (DevkitNotification)Message.RESTHTTPCLIENT_MISSING_GETTER, new Object[]{httpClientField.getName()});
        }
    }
}

