/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.oauth.generation.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationValue;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.store.ObjectStore;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.oauth.OAuthCallbackParameterField;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.oauth.generation.AbstractOAuthAdapterGenerator;
import org.mule.devkit.oauth.generation.adapter.OAuth2ClientAdapterGenerator;
import org.mule.devkit.oauth.generation.manager.AbstractOAuthManagerGenerator;
import org.mule.devkit.oauth.generation.manager.factory.OAuthClientFactoryGenerator;
import org.mule.devkit.utils.NameUtils;
import org.mule.security.oauth.BaseOAuth2Manager;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.OnNoTokenPolicy;

public abstract class AbstractOAuth2ManagerGenerator
extends AbstractOAuthManagerGenerator {
    @Override
    protected TypeReference getExtendManagerClass() {
        return this.ref(BaseOAuth2Manager.class).narrow(OAuth2Adapter.class);
    }

    @Override
    protected AbstractOAuthAdapterGenerator getAdapterGenerator() {
        return new OAuth2ClientAdapterGenerator();
    }

    @Override
    public void doGenerate(Module module, GeneratedClass oAuthManagerClass) throws GenerationException {
        OAuthCapability oAuthCapability = this.getOAuthCapability(module);
        this.callGenerator(module, this.getOAuthFactoryGenerator());
        GeneratedClass adapterClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass oauthClientFactoryClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH2_FACTORY, (Identifiable)module);
        this.generateConfigurableFields(module, oAuthManagerClass, oAuthCapability, adapterClass);
        this.generateInstantiateMethod(module, oAuthManagerClass);
        this.generateCreatePoolFactoryMethod(oauthClientFactoryClass, oAuthManagerClass);
        this.generateSetCustomPropertiesMethod(module, adapterClass, oAuthManagerClass, oAuthCapability);
        this.generateFetchCallbackParameters(module, oAuthCapability, oAuthManagerClass, adapterClass);
        this.generateSetOnNoTokenPolicy(oAuthManagerClass);
        this.generateRefreshAccessTokenOn(module, oAuthManagerClass);
    }

    protected abstract OAuthCapability getOAuthCapability(Module var1);

    protected abstract GeneratedExpression wrapAccessorConnector(Module var1, Field var2, GeneratedExpression var3);

    protected abstract List<Field> getConfigurableFields(Module var1);

    protected OAuthClientFactoryGenerator getOAuthFactoryGenerator() {
        return new OAuthClientFactoryGenerator();
    }

    private void generateConfigurableFields(Module module, GeneratedClass oAuthManagerClass, OAuthCapability oAuthCapability, GeneratedClass adapterClass) {
        for (Field field : this.getConfigurableFields(module)) {
            GeneratedVariable value;
            GeneratedMethod setter;
            if (oAuthCapability.getConsumerKeyField().equals(field)) {
                setter = oAuthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, NameUtils.buildSetter((String)field.getName()));
                setter.javadoc().add((Object)("Sets " + field.getName()));
                setter.javadoc().addParam("key to set");
                value = setter.param((Type)this.ref(String.class), "value");
                setter.body().add((Statement)ExpressionFactory._super().invoke("setConsumerKey").arg((GeneratedExpression)value));
                continue;
            }
            if (oAuthCapability.getConsumerSecretField().equals(field)) {
                setter = oAuthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, NameUtils.buildSetter((String)field.getName()));
                setter.javadoc().add((Object)("Sets " + field.getName()));
                setter.javadoc().addParam("secret to set");
                value = setter.param((Type)this.ref(String.class), "value");
                setter.body().add((Statement)ExpressionFactory._super().invoke("setConsumerSecret").arg((GeneratedExpression)value));
                continue;
            }
            if (oAuthCapability.getScopeField() != null && oAuthCapability.getScopeField().equals(field)) {
                setter = oAuthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, NameUtils.buildSetter((String)field.getName()));
                setter.javadoc().add((Object)("Sets " + field.getName()));
                setter.javadoc().addParam("scope to set");
                value = setter.param((Type)this.ref(String.class), "value");
                setter.body().add((Statement)ExpressionFactory._super().invoke("setScope").arg((GeneratedExpression)value));
                continue;
            }
            setter = oAuthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, NameUtils.buildSetter((String)field.getName()));
            setter.javadoc().add((Object)("Sets " + field.getName()));
            setter.javadoc().addParam("scope to set");
            value = setter.param(this.ref(field.asTypeMirror()), "value");
            GeneratedVariable setterConnector = setter.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)ExpressionFactory._this().invoke("getDefaultUnauthorizedConnector")));
            setterConnector = this.wrapAccessorConnector(module, field, (GeneratedExpression)setterConnector);
            setter.body().add((Statement)setterConnector.invoke(setter.name()).arg((GeneratedExpression)value));
            GeneratedMethod getter = oAuthManagerClass.method(1, this.ref(field.asTypeMirror()), NameUtils.buildGetter((String)field.getName()));
            getter.javadoc().add((Object)("Retrieves " + field.getName()));
            GeneratedVariable getterConnector = getter.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)ExpressionFactory._this().invoke("getDefaultUnauthorizedConnector")));
            getterConnector = this.wrapAccessorConnector(module, field, (GeneratedExpression)getterConnector);
            getter.body()._return((GeneratedExpression)getterConnector.invoke(getter.name()));
        }
    }

    private void generateSetOnNoTokenPolicy(GeneratedClass oauthManagerClass) {
        GeneratedMethod setOnNoTokenPolicyMethod = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setOnNoToken");
        GeneratedVariable policy = setOnNoTokenPolicyMethod.param((Type)this.ref(OnNoTokenPolicy.class), "policy");
        setOnNoTokenPolicyMethod.body().add((Statement)ExpressionFactory._this().invoke("getDefaultUnauthorizedConnector").invoke("setOnNoTokenPolicy").arg((GeneratedExpression)policy));
    }

    private void generateRefreshAccessTokenOn(Module module, GeneratedClass oauthManagerClass) {
        ArrayList<GeneratedExpression> exceptionClasses = new ArrayList<GeneratedExpression>();
        for (AnnotationValue reconnectionException : module.reconnectOn()) {
            exceptionClasses.add(this.ref(reconnectionException.getValue().toString()).boxify().dotclass());
        }
        for (ProcessorMethod processor : module.getProcessorMethods()) {
            for (AnnotationValue annotationValue : processor.reconnectOn()) {
                exceptionClasses.add(this.ref(annotationValue.getValue().toString()).boxify().dotclass());
            }
        }
        if (exceptionClasses.isEmpty()) {
            for (ProcessorMethod processor : module.getProcessorMethods()) {
                if (processor.invalidateAccessTokenOn() == null) continue;
                exceptionClasses.add(this.ref(processor.invalidateAccessTokenOn()).boxify().dotclass());
            }
        }
        if (!exceptionClasses.isEmpty()) {
            GeneratedMethod method = oauthManagerClass.method(2, (Type)this.ref(Set.class).narrow(this.ref(Class.class).narrow(this.ref(Exception.class).wildcard())), "refreshAccessTokenOn");
            method.annotate(Override.class);
            GeneratedVariable set = method.body().decl((Type)this.ref(Set.class).narrow(this.ref(Class.class).narrow(this.ref(Exception.class).wildcard())), "types", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HashSet.class).narrow(this.ref(Class.class).narrow(this.ref(Exception.class).wildcard()))));
            for (GeneratedExpression type : exceptionClasses) {
                method.body().invoke((GeneratedExpression)set, "add").arg(type);
            }
            method.body()._return((GeneratedExpression)set);
        }
    }

    private void generateFetchCallbackParameters(Module module, OAuthCapability oAuthCapability, GeneratedClass oauthManagerClass, GeneratedClass adapterClass) {
        GeneratedMethod fetchCallbackParameters = oauthManagerClass.method(2, (Type)this.context.getCodeModel().VOID, "fetchCallbackParameters");
        GeneratedVariable adapter = fetchCallbackParameters.param((Type)this.ref(OAuth2Adapter.class), "adapter");
        GeneratedVariable response = fetchCallbackParameters.param((Type)this.ref(String.class), "response");
        GeneratedVariable connector = fetchCallbackParameters.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)adapter));
        GeneratedBlock body = fetchCallbackParameters.body();
        GeneratedVariable expressionManager = body.decl((Type)this.ref(ExpressionManager.class), "expressionManager", ExpressionFactory.direct((String)"muleContext.getExpressionManager()"));
        GeneratedVariable muleMessage = body.decl((Type)this.ref(MuleMessage.class), "muleMessage", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMuleMessage.class)).arg((GeneratedExpression)response).arg(ExpressionFactory.direct((String)"muleContext")));
        for (OAuthCallbackParameterField field : oAuthCapability.getCallbackParameters()) {
            GeneratedExpression castedConnector = OAuth2StrategyUtilsResolver.getOAuthConcreteComponent((Module)module, (GeneratedExpression)connector, (Context)this.ctx());
            GeneratedInvocation invocation = castedConnector.invoke(NameUtils.buildSetter((String)field.getName())).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(field.asTypeMirror()), (GeneratedExpression)expressionManager.invoke("evaluate").arg(field.getExpression()).arg((GeneratedExpression)muleMessage)));
            body.add((Statement)invocation);
        }
    }

    private void generateSetCustomPropertiesMethod(Module module, GeneratedClass adapterClass, GeneratedClass oauthManagerClass, OAuthCapability oAuthCapability) {
        GeneratedMethod setCustomPropertiesMethod = oauthManagerClass.method(2, (Type)this.ctx().getCodeModel().VOID, "setCustomProperties");
        setCustomPropertiesMethod.annotate(Override.class);
        GeneratedVariable adapter = setCustomPropertiesMethod.param((Type)this.ref(OAuth2Adapter.class), "adapter");
        GeneratedVariable connector = setCustomPropertiesMethod.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)adapter));
        for (Field field : this.getConfigurableFields(module)) {
            String fieldGetterMethod = this.getSetterFieldMethod(oAuthCapability, field);
            GeneratedExpression targetObjectToSetField = this.wrapAccessorConnector(module, field, (GeneratedExpression)connector);
            GeneratedInvocation setterField = targetObjectToSetField.invoke(NameUtils.buildSetter((String)field.getName())).arg((GeneratedExpression)ExpressionFactory.invoke((String)fieldGetterMethod));
            setCustomPropertiesMethod.body().add((Statement)setterField);
        }
    }

    private String getSetterFieldMethod(OAuthCapability oAuthCapability, Field field) {
        String fieldGetterMethod = NameUtils.buildGetter((String)field.getName());
        if (oAuthCapability.getConsumerKeyField().equals(field)) {
            fieldGetterMethod = "getConsumerKey";
        } else if (oAuthCapability.getConsumerSecretField().equals(field)) {
            fieldGetterMethod = "getConsumerSecret";
        } else if (oAuthCapability.getScopeField() != null && oAuthCapability.getScopeField().equals(field)) {
            fieldGetterMethod = "getScope";
        }
        return fieldGetterMethod;
    }

    private void generateCreatePoolFactoryMethod(GeneratedClass oauthClientFactoryClass, GeneratedClass oauthManagerClass) {
        GeneratedMethod createPoolFactoryMethod = oauthManagerClass.method(2, (Type)this.ref(KeyedPoolableObjectFactory.class), "createPoolFactory");
        createPoolFactoryMethod.annotate(Override.class);
        GeneratedVariable oauthManager = createPoolFactoryMethod.param((Type)this.ref(OAuth2Manager.class).narrow(OAuth2Adapter.class), "oauthManager");
        GeneratedVariable objectStore = createPoolFactoryMethod.param((Type)this.ref(ObjectStore.class).narrow(Serializable.class), "objectStore");
        createPoolFactoryMethod.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)oauthClientFactoryClass).arg((GeneratedExpression)oauthManager).arg((GeneratedExpression)objectStore));
    }

    private void generateInstantiateMethod(Module module, GeneratedClass oauthManagerClass) {
        GeneratedMethod instantiateMethod = oauthManagerClass.method(2, (Type)this.ref(OAuth2Adapter.class), "instantiateAdapter");
        instantiateMethod.annotate(Override.class);
        if (module.hasRestCalls()) {
            instantiateMethod.body().directStatement("return new " + module.getPackage().getName() + ".adapters." + module.getClassName() + "RestClientAdapter(this);");
        } else {
            GeneratedClass oauthAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module);
            instantiateMethod.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)oauthAdapterClass.topLevelClass()).arg(ExpressionFactory._this()));
        }
    }
}

