/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.oauth.generation.config;

import org.mule.api.processor.MessageProcessor;
import org.mule.config.spring.factories.MessageProcessorChainFactoryBean;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.oauth.generation.AbstractOAuthAdapterGenerator;
import org.mule.devkit.oauth.generation.OAuthClientNamingConstants;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.security.oauth.callback.DefaultRestoreAccessTokenCallback;

import java.util.Arrays;
import java.util.List;

@JustOnce
public class DefaultRestoreAccessTokenCallbackFactoryGenerator extends AbstractOAuthAdapterGenerator {
    private final static List<Product> CONSUMES = Arrays.asList();
    private final static List<Product> PRODUCES = Arrays.asList(Product.DEFAULT_RESTORE_ACCESS_TOKEN_CALLBACK_FACTORY);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule
                && ((OAuthModule)module).getOAuthVersion().equals(OAuthVersion.V10A);
    }

    @Override
    public void generate(Module module) throws GenerationException {
        GeneratedClass factory = getDefaultRestoreAccessTokenCallbackFactoryClass(module);

        GeneratedMethod getObjectType = factory.method(Modifier.PUBLIC, ref(Class.class), "getObjectType");
        getObjectType.body()._return(ref(DefaultRestoreAccessTokenCallback.class).dotclass());

        GeneratedMethod getObject = factory.method(Modifier.PUBLIC, ref(Object.class), "getObject");
        getObject._throws(ref(Exception.class));
        GeneratedVariable callbackVariable = getObject.body().decl(ref(DefaultRestoreAccessTokenCallback.class), "callback", ExpressionFactory._new(ref(DefaultRestoreAccessTokenCallback.class)));
        getObject.body().add(
                callbackVariable.invoke("setMessageProcessor").arg(
                        ExpressionFactory.cast(ref(MessageProcessor.class),
                                ExpressionFactory._super().invoke("getObject"))));

        getObject.body()._return(callbackVariable);
    }

    private GeneratedClass getDefaultRestoreAccessTokenCallbackFactoryClass(Module module) {
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.CONFIG_NAMESPACE);
        GeneratedClass clazz = pkg._class(OAuthClientNamingConstants.RESTORE_ACCESS_TOKEN_CALLBACK_FACTORY_BEAN_CLASS_NAME);
        clazz._extends(ref(MessageProcessorChainFactoryBean.class));
        ctx().registerProduct(Product.DEFAULT_RESTORE_ACCESS_TOKEN_CALLBACK_FACTORY, clazz);

        return clazz;
    }
}
