/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.oauth.generation.adapter;

import oauth.signpost.OAuthConsumer;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.SigningStrategy;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.common.security.oauth.exception.UnableToAcquireAccessTokenException;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.oauth.generation.AbstractOAuthAdapterGenerator;
import org.mule.security.oauth.OAuth1Adapter;
import org.mule.security.oauth.OAuth1Manager;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.mule.security.oauth.process.OAuthProcessTemplate;

public class OAuth1ClientAdapterGenerator
extends AbstractOAuthAdapterGenerator {
    public boolean shouldGenerate(Module module) {
        return false;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass oauthAdapter = this.getOAuthAdapterClass(module, "OAuth1Adapter", this.ref(OAuth1Adapter.class));
        oauthAdapter._implements(OAuth1Adapter.class);
        OAuthModule oAuthModule = (OAuthModule)module;
        OAuth oauth = (OAuth)module.getAnnotation(OAuth.class);
        GeneratedClass oauthManagerClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module);
        GeneratedField oauthManager = this.createOauthManager(oauthAdapter);
        GeneratedField requestToken = this.requestTokenField(oauthAdapter);
        GeneratedField requestTokenSecret = this.requestTokenSecretField(oauthAdapter);
        GeneratedField oauthVerifier = this.authorizationCodeField(oauthAdapter);
        GeneratedField saveAccessTokenCallback = this.saveAccessTokenCallbackField(oauthAdapter);
        GeneratedField restoreAccessTokenCallback = this.restoreAccessTokenCallbackField(oauthAdapter);
        GeneratedField authorizationUrl = this.generateAuthorizationUrlField(oauthAdapter);
        GeneratedField accessTokenUrl = this.generateAccessTokenUrlField(oauthAdapter);
        GeneratedField requestTokenUrl = this.generateRequestTokenUrlField(oauthAdapter);
        GeneratedField onNoTokenPolicy = this.generateOnNoTokenPolicy(oauthAdapter);
        this.generateAdapterInterfaceImplementations(oauthAdapter, module);
        this.generateCallbackGettersAndSetters(oauthAdapter);
        this.generateName(oauthAdapter);
        this.consumerField(oauthAdapter);
        GeneratedMethod constructor = oauthAdapter.constructor(1);
        GeneratedVariable oauthManagerParam = constructor.param((Type)this.ref(OAuth1Manager.class), "oauthManager");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)oauthManager), (GeneratedExpression)oauthManagerParam);
        this.generateOAuth1AuthorizeMethod(oauthAdapter, oauthManager);
        this.generateRestoreAccessTokenMethod(oauthAdapter, oauthManager);
        this.generateFetchAccessTokenMethod(oauthAdapter, oauthManager);
        this.generateGetOAuth1ManagerMethod(oauthAdapter, oauthManager);
        this.generateHasBeenAuthorizedMethod(oAuthModule, oauthAdapter);
        this.generateGetProcessTemplateMethod(oAuthModule, oauthAdapter, (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module));
        this.generateResetMethod(oAuthModule, oauthAdapter);
    }

    private void generateAdapterInterfaceImplementations(GeneratedClass oauthAdapter, Module module) {
        OAuthModule oAuthModule = (OAuthModule)module;
        if (!oAuthModule.hasMethodWithName("getConsumerKey")) {
            GeneratedMethod getConsumerKeyMethod = oauthAdapter.method(1, (Type)this.ref(String.class), "getConsumerKey");
            getConsumerKeyMethod.annotate(Override.class);
            getConsumerKeyMethod.body()._return((GeneratedExpression)ExpressionFactory._this().invoke(oAuthModule.getConsumerKeyField().getGetter().getName()));
        }
        if (!oAuthModule.hasMethodWithName("getConsumerSecret")) {
            GeneratedMethod getConsumerSecret = oauthAdapter.method(1, (Type)this.ref(String.class), "getConsumerSecret");
            getConsumerSecret.annotate(Override.class);
            getConsumerSecret.body()._return((GeneratedExpression)ExpressionFactory._this().invoke(oAuthModule.getConsumerSecretField().getGetter().getName()));
        }
        if (!oAuthModule.hasMethodWithName("getAccessToken")) {
            GeneratedMethod getAccessToken = oauthAdapter.method(1, (Type)this.ref(String.class), "getAccessToken");
            getAccessToken.annotate(Override.class);
            getAccessToken.body()._return((GeneratedExpression)ExpressionFactory._this().ref(oAuthModule.getAccessTokenField().getGetter().getName()));
        }
        if (!oAuthModule.hasMethodWithName("getScope")) {
            GeneratedMethod getScope = oauthAdapter.method(1, (Type)this.ref(String.class), "getScope");
            getScope.annotate(Override.class);
            if (oAuthModule.getScopeField() != null) {
                getScope.body()._return((GeneratedExpression)ExpressionFactory._this().invoke(oAuthModule.getScopeField().getGetter().getName()));
            } else {
                getScope.body()._return(ExpressionFactory.lit((String)""));
            }
        }
        if (!oAuthModule.hasMethodWithName("getVerifierRegex")) {
            GeneratedMethod getVerifierRegex = oauthAdapter.method(1, (Type)this.ref(String.class), "getVerifierRegex");
            getVerifierRegex.annotate(Override.class);
            getVerifierRegex.body()._return(ExpressionFactory.lit((String)oAuthModule.getVerifierRegex()));
        }
        if (!oAuthModule.hasMethodWithName("getMessageSigner")) {
            GeneratedMethod getMessageSigner = oauthAdapter.method(1, (Type)this.ref(OAuthMessageSigner.class), "getMessageSigner");
            getMessageSigner.annotate(Override.class);
            getMessageSigner.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HmacSha1MessageSigner.class)));
        }
        if (!oAuthModule.hasMethodWithName("getSigningStrategy")) {
            GeneratedMethod getSigningStrategy = oauthAdapter.method(1, (Type)this.ref(SigningStrategy.class), "getSigningStrategy");
            getSigningStrategy.annotate(Override.class);
            getSigningStrategy.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(AuthorizationHeaderSigningStrategy.class)));
        }
    }

    private void generateName(GeneratedClass oauthAdapter) {
        oauthAdapter.direct("String name;\n    \n    public String getName() {\n        return name;\n    }\n\n    public void setName(String name) {\n        this.name = name;\n    }");
    }

    private void generateCallbackGettersAndSetters(GeneratedClass oauthAdapter) {
        oauthAdapter.direct(" public Integer getLocalPort() {\n        return oauthManager.getLocalPort();\n    }\n\n    public Integer getRemotePort() {\n        return oauthManager.getRemotePort();\n    }\n\n    public String getDomain() {\n        return oauthManager.getDomain();\n    }\n\n    public String getPath() {\n        return oauthManager.getPath();\n    }\n\n    public org.mule.api.transport.Connector getConnector() {\n        return oauthManager.getConnector();\n    }\n\n    public void setConnector(org.mule.api.transport.Connector value) {\n        oauthManager.setConnector(value);\n    }\n\n    public Boolean getAsync() {\n        return oauthManager.getAsync();\n    }\n\n    public void setAsync(Boolean async) {\n        oauthManager.setAsync(async);\n    }\n\n    public void setLocalPort(Integer value) {\n        oauthManager.setLocalPort(value);\n    }\n\n    public void setRemotePort(Integer value) {\n        oauthManager.setRemotePort(value);\n    }\n\n    public void setDomain(String value) {\n        oauthManager.setDomain(value);\n    }\n\n    public void setPath(String value) {\n        oauthManager.setPath(value);\n    }");
    }

    private void generatePathSetter(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod setPathMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setPath");
        GeneratedVariable value = setPathMethod.param((Type)this.ref(String.class), "value");
        setPathMethod.body().add((Statement)oauthManager.invoke("setPath").arg((GeneratedExpression)value));
    }

    private void generateSetDomain(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod setDomainMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setDomain");
        GeneratedVariable value = setDomainMethod.param((Type)this.ref(String.class), "value");
        setDomainMethod.body().add((Statement)oauthManager.invoke("setDomain").arg((GeneratedExpression)value));
    }

    private void generateSetRemotePort(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod setRemotePortMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setRemotePort");
        GeneratedVariable value = setRemotePortMethod.param((Type)this.ref(Integer.class), "value");
        setRemotePortMethod.body().add((Statement)oauthManager.invoke("setRemotePort").arg((GeneratedExpression)value));
    }

    private void generateSetLocalPort(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod setLocalPortMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setLocalPort");
        GeneratedVariable value = setLocalPortMethod.param((Type)this.ref(Integer.class), "value");
        setLocalPortMethod.body().add((Statement)oauthManager.invoke("setLocalPort").arg((GeneratedExpression)value));
    }

    private void generateGetOAuth1ManagerMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod getOAuth1ManagerMethod = oauthAdapter.method(1, (Type)this.ref(OAuth1Manager.class), "getOauth1Manager");
        getOAuth1ManagerMethod.body()._return((GeneratedExpression)oauthManager);
        getOAuth1ManagerMethod.annotate(Override.class);
    }

    private GeneratedField createOauthManager(GeneratedClass oauthAdapter) {
        GeneratedField oauthManager = oauthAdapter.field(4, (Type)this.ref(OAuth1Manager.class), "oauthManager");
        oauthAdapter.getter(oauthManager);
        oauthAdapter.setter(oauthManager);
        return oauthManager;
    }

    private GeneratedField generateOnNoTokenPolicy(GeneratedClass oauthAdapter) {
        FieldBuilder fieldBuilder = new FieldBuilder(oauthAdapter);
        fieldBuilder.initialValue((GeneratedExpression)this.ref(OnNoTokenPolicy.class).staticRef("EXCEPTION"));
        GeneratedMethod setOnNoToken = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setOnNoToken");
        GeneratedField result = fieldBuilder.type(OnNoTokenPolicy.class).name("onNoTokenPolicy").getterAndSetter().build();
        GeneratedVariable value = setOnNoToken.param((Type)this.ref(OnNoTokenPolicy.class), "value");
        setOnNoToken.body().add((Statement)ExpressionFactory.invoke((String)"setOnNoTokenPolicy").arg((GeneratedExpression)value));
        return result;
    }

    private GeneratedField requestTokenField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("requestToken").getterAndSetter().build();
    }

    private GeneratedField requestTokenSecretField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("requestTokenSecret").getterAndSetter().build();
    }

    private GeneratedField consumerField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(OAuthConsumer.class).name("consumer").getterAndSetter().build();
    }

    private void generateRestoreAccessTokenMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod restoreAccessTokenMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "restoreAccessToken");
        restoreAccessTokenMethod.body()._return((GeneratedExpression)oauthManager.invoke("restoreAccessToken").arg(ExpressionFactory._this()));
    }

    private void generateFetchAccessTokenMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod fetchAccessToken = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "fetchAccessToken");
        GeneratedVariable requestTokenUrl = fetchAccessToken.param((Type)this.ref(String.class), "requestTokenUrl");
        GeneratedVariable accessTokenUrl = fetchAccessToken.param((Type)this.ref(String.class), "accessTokenUrl");
        GeneratedVariable authorizationUrl = fetchAccessToken.param((Type)this.ref(String.class), "authorizationUrl");
        GeneratedVariable redirectUri = fetchAccessToken.param((Type)this.ref(String.class), "redirectUri");
        fetchAccessToken._throws(this.ref(UnableToAcquireAccessTokenException.class));
        fetchAccessToken.body().add((Statement)oauthManager.invoke("fetchAccessToken").arg(ExpressionFactory._this()).arg((GeneratedExpression)requestTokenUrl).arg((GeneratedExpression)accessTokenUrl).arg((GeneratedExpression)authorizationUrl).arg((GeneratedExpression)redirectUri));
    }

    private void generateResetMethod(OAuthModule module, GeneratedClass oauthAdapter) {
        GeneratedMethod reset = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "reset");
        reset.body().invoke(module.getAccessTokenField().getSetter().getName()).arg(ExpressionFactory._null());
        reset.body().invoke(module.getAccessTokenSecretField().getSetter().getName()).arg(ExpressionFactory._null());
        GeneratedField consumer = (GeneratedField)oauthAdapter.fields().get("consumer");
        reset.body().add((Statement)consumer.invoke("setTokenWithSecret").arg(ExpressionFactory._null()).arg(ExpressionFactory._null()));
    }

    protected void generateGetProcessTemplateMethod(OAuthModule module, GeneratedClass oauthAdapterClass, GeneratedClass capabilitiesAdapterClass) {
        GeneratedMethod getProcessTemplate = oauthAdapterClass.method(1, (Type)this.ref(ProcessTemplate.class), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)p).narrow((TypeReference)capabilitiesAdapterClass));
        GeneratedInvocation newProcessTemplate = ExpressionFactory._new((TypeReference)this.ref(OAuthProcessTemplate.class)).arg(ExpressionFactory._this());
        getProcessTemplate.body()._return((GeneratedExpression)newProcessTemplate);
    }
}

