/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.processors;

import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractAuthorizationCodeMessageProcessorGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(new Product[0]);
    private static final List<Product> PRODUCES = Arrays.asList(Product.OAUTH_EXTRACT_AUTHORIZATION_CODE_MESSAGE_PROCESSOR);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return false;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass messageProcessor = this.getExtractAuthorizationCodeMessageProcessorClass(module);
        GeneratedField pattern = messageProcessor.field(4, (Type)this.ref(Pattern.class), "pattern");
        this.generateConstructor(messageProcessor, pattern);
        GeneratedMethod processMethod = messageProcessor.method(1, (Type)this.ref(MuleEvent.class), "process")._throws(this.ref(MuleException.class));
        GeneratedVariable event = processMethod.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedTry tryToExtractVerifier = processMethod.body()._try();
        tryToExtractVerifier.body().add((Statement)event.invoke("getMessage").invoke("setInvocationProperty").arg("_oauthVerifier").arg((GeneratedExpression)ExpressionFactory.invoke((String)"extractAuthorizationCode").arg((GeneratedExpression)event.invoke("getMessageAsString"))));
        GeneratedCatchBlock catchBlock = tryToExtractVerifier._catch(this.ref(Exception.class));
        GeneratedVariable exceptionCaught = catchBlock.param("e");
        catchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MessagingException.class)).arg((GeneratedExpression)this.ref(MessageFactory.class).staticInvoke("createStaticMessage").arg("Could not extract OAuth verifier")).arg((GeneratedExpression)event).arg((GeneratedExpression)exceptionCaught));
        processMethod.body()._return((GeneratedExpression)event);
        GeneratedMethod extractMethod = messageProcessor.method(4, (Type)this.ref(String.class), "extractAuthorizationCode")._throws(this.ref(Exception.class));
        GeneratedVariable response = extractMethod.param(String.class, "response");
        GeneratedVariable matcher = extractMethod.body().decl((Type)this.ref(Matcher.class), "matcher", (GeneratedExpression)pattern.invoke("matcher").arg((GeneratedExpression)response));
        GeneratedConditional ifVerifierFound = extractMethod.body()._if(Op.cand((GeneratedExpression)matcher.invoke("find"), (GeneratedExpression)Op.gte((GeneratedExpression)matcher.invoke("groupCount"), (GeneratedExpression)ExpressionFactory.lit((int)1))));
        GeneratedInvocation group = matcher.invoke("group").arg(ExpressionFactory.lit((int)1));
        ifVerifierFound._then()._return((GeneratedExpression)this.ref(URLDecoder.class).staticInvoke("decode").arg((GeneratedExpression)group).arg("UTF-8"));
        ifVerifierFound._else()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Exception.class)).arg((GeneratedExpression)this.ref(String.class).staticInvoke("format").arg("OAuth authorization code could not be extracted from: %s").arg((GeneratedExpression)response)));
    }

    private void generateConstructor(GeneratedClass messageProcessor, GeneratedField patternField) {
        GeneratedMethod constructor = messageProcessor.constructor(1);
        GeneratedVariable pattern = constructor.param((Type)this.ref(Pattern.class), "pattern");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)patternField), (GeneratedExpression)pattern);
    }

    private GeneratedClass getExtractAuthorizationCodeMessageProcessorClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._class("ExtractAuthorizationCodeMessageProcessor", new Class[]{MessageProcessor.class});
        this.ctx().registerProduct(Product.OAUTH_EXTRACT_AUTHORIZATION_CODE_MESSAGE_PROCESSOR, (Object)clazz);
        return clazz;
    }
}

