/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import oauth.signpost.OAuthConsumer;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.store.ObjectStore;
import org.mule.common.security.oauth.OAuthState;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuth1ClientAdapterGenerator;
import org.mule.devkit.generation.oauth.OAuth2ClientAdapterGenerator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.oauth.OAuthCallbackParameterField;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.security.oauth.BaseOAuth1Manager;
import org.mule.security.oauth.BaseOAuth2Manager;
import org.mule.security.oauth.BaseOAuthClientFactory;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.mule.util.StringUtils;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthManagerGenerator
extends AbstractOAuthAdapterGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.INJECTION_ADAPTER, Product.MANAGED_ACCESS_TOKEN_PROCESS_TEMPLATE, Product.METADATA_ADAPTER, Product.PROCESS_INTERFACES);
    private static final List<Product> PRODUCES = Arrays.asList(Product.OAUTH_MANAGER, Product.OAUTH_ADAPTER);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule;
    }

    public void generate(Module module) throws GenerationException {
        OAuthModule oauthModule = (OAuthModule)module;
        GeneratedClass oauthManagerClass = this.getOAuthManagerClass(oauthModule);
        GeneratedField logger = this.generateLoggerField(oauthManagerClass);
        this.getLoggerMethod(oauthManagerClass, logger);
        AbstractOAuthAdapterGenerator oauthAdapterGenerator = null;
        if (((OAuthModule)module).getOAuthVersion().equals((Object)OAuthVersion.V2)) {
            oauthAdapterGenerator = new OAuth2ClientAdapterGenerator();
            oauthAdapterGenerator.setCtx(this.ctx());
            oauthAdapterGenerator.generate(module);
        } else {
            oauthAdapterGenerator = new OAuth1ClientAdapterGenerator();
            oauthAdapterGenerator.setCtx(this.ctx());
            oauthAdapterGenerator.generate(module);
        }
        if (((OAuthModule)module).getOAuthVersion().equals((Object)OAuthVersion.V10A)) {
            return;
        }
        GeneratedClass oauthClientFactoryClass = this.getOAuthClientFactoryClass(module);
        GeneratedClass adapterClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass stateClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_STATE, (Identifiable)module);
        GeneratedField oauthManager = this.generateOAuthManagerClientFactoryField(oauthClientFactoryClass, oauthManagerClass);
        this.generateOAuthClientFactoryConstructor(oauthManagerClass, oauthClientFactoryClass);
        this.generateGetAdapterClassMethod(module, oauthClientFactoryClass, adapterClass);
        this.generateSetCustomAdapterPropertiesMethod(module, oauthClientFactoryClass, adapterClass, stateClass, oauthManager);
        this.generateSetCustomStateProperties(module, oauthClientFactoryClass, adapterClass, stateClass);
        for (Field field : module.getConfigurableFields()) {
            GeneratedVariable value;
            GeneratedMethod setter;
            if (((OAuthModule)module).getConsumerKeyField().equals(field)) {
                setter = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName()));
                setter.javadoc().add((Object)("Sets " + field.getName()));
                setter.javadoc().addParam("key to set");
                value = setter.param((Type)this.ref(String.class), "value");
                setter.body().add((Statement)ExpressionFactory._super().invoke("setConsumerKey").arg((GeneratedExpression)value));
                continue;
            }
            if (((OAuthModule)module).getConsumerSecretField().equals(field)) {
                setter = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName()));
                setter.javadoc().add((Object)("Sets " + field.getName()));
                setter.javadoc().addParam("secret to set");
                value = setter.param((Type)this.ref(String.class), "value");
                setter.body().add((Statement)ExpressionFactory._super().invoke("setConsumerSecret").arg((GeneratedExpression)value));
                continue;
            }
            if (((OAuthModule)module).getScopeField() != null && ((OAuthModule)module).getScopeField().equals(field)) {
                setter = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName()));
                setter.javadoc().add((Object)("Sets " + field.getName()));
                setter.javadoc().addParam("scope to set");
                value = setter.param((Type)this.ref(String.class), "value");
                setter.body().add((Statement)ExpressionFactory._super().invoke("setScope").arg((GeneratedExpression)value));
                continue;
            }
            setter = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName()));
            setter.javadoc().add((Object)("Sets " + field.getName()));
            setter.javadoc().addParam("scope to set");
            value = setter.param(this.ref(field.asTypeMirror()), "value");
            GeneratedVariable setterConnector = setter.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)ExpressionFactory._this().invoke("getDefaultUnauthorizedConnector")));
            setter.body().add((Statement)setterConnector.invoke(setter.name()).arg((GeneratedExpression)value));
            GeneratedMethod getter = oauthManagerClass.method(1, this.ref(field.asTypeMirror()), "get" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName()));
            getter.javadoc().add((Object)("Retrieves " + field.getName()));
            GeneratedVariable getterConnector = getter.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)ExpressionFactory._this().invoke("getDefaultUnauthorizedConnector")));
            getter.body()._return((GeneratedExpression)getterConnector.invoke(getter.name()));
        }
        this.generateMetadataConstantsAndGetters(module, oauthManagerClass);
        if (oauthModule.getOAuthVersion() == OAuthVersion.V2) {
            this.generateInstantiateMethod(module, oauthManagerClass);
            this.generateCreatePoolFactoryMethod(oauthClientFactoryClass, oauthManagerClass);
            this.generateSetCustomPropertiesMethod(module, adapterClass, oauthManagerClass);
            this.generateFetchCallbackParameters(oauthModule, oauthManagerClass, adapterClass);
            this.generateSetOnNoTokenPolicy(oauthManagerClass);
            this.generateRefreshAccessTokenOn(oauthModule, oauthManagerClass);
        }
    }

    private GeneratedField generateOAuthManagerClientFactoryField(GeneratedClass oauthClientFactoryClass, GeneratedClass oauthManagerClass) {
        return oauthClientFactoryClass.field(4, (Type)oauthManagerClass, "oauthManager");
    }

    private void generateSetOnNoTokenPolicy(GeneratedClass oauthManagerClass) {
        GeneratedMethod setOnNoTokenPolicyMethod = oauthManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setOnNoToken");
        GeneratedVariable policy = setOnNoTokenPolicyMethod.param((Type)this.ref(OnNoTokenPolicy.class), "policy");
        setOnNoTokenPolicyMethod.body().add((Statement)ExpressionFactory._this().invoke("getDefaultUnauthorizedConnector").invoke("setOnNoTokenPolicy").arg((GeneratedExpression)policy));
    }

    private void getLoggerMethod(GeneratedClass oauthManagerClass, GeneratedField logger) {
        GeneratedMethod getLoggerMethod = oauthManagerClass.method(2, (Type)this.ref(Logger.class), "getLogger");
        getLoggerMethod.annotate(Override.class);
        getLoggerMethod.body()._return((GeneratedExpression)logger);
    }

    private void generateRefreshAccessTokenOn(OAuthModule module, GeneratedClass oauthManagerClass) {
        HashSet<DeclaredType> exceptions = new HashSet<DeclaredType>();
        for (ProcessorMethod processor : module.getProcessorMethods()) {
            if (processor.invalidateAccessTokenOn() == null) continue;
            exceptions.add(processor.invalidateAccessTokenOn());
        }
        if (!exceptions.isEmpty()) {
            GeneratedMethod method = oauthManagerClass.method(2, (Type)this.ref(Set.class).narrow(this.ref(Class.class).narrow(this.ref(Exception.class).wildcard())), "refreshAccessTokenOn");
            method.annotate(Override.class);
            GeneratedVariable set = method.body().decl((Type)this.ref(Set.class).narrow(this.ref(Class.class).narrow(this.ref(Exception.class).wildcard())), "types", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HashSet.class).narrow(this.ref(Class.class).narrow(this.ref(Exception.class).wildcard()))));
            for (DeclaredType type : exceptions) {
                method.body().invoke((GeneratedExpression)set, "add").arg(ExpressionFactory.direct((String)(type + ".class")));
            }
            method.body()._return((GeneratedExpression)set);
        }
    }

    private void generateFetchCallbackParameters(OAuthModule module, GeneratedClass oauthManagerClass, GeneratedClass adapterClass) {
        GeneratedMethod fetchCallbackParameters = oauthManagerClass.method(2, (Type)this.context.getCodeModel().VOID, "fetchCallbackParameters");
        GeneratedVariable adapter = fetchCallbackParameters.param((Type)this.ref(OAuth2Adapter.class), "adapter");
        GeneratedVariable response = fetchCallbackParameters.param((Type)this.ref(String.class), "response");
        GeneratedVariable connector = fetchCallbackParameters.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)adapter));
        GeneratedBlock body = fetchCallbackParameters.body();
        GeneratedVariable expressionManager = body.decl((Type)this.ref(ExpressionManager.class), "expressionManager", ExpressionFactory.direct((String)"muleContext.getExpressionManager()"));
        GeneratedVariable muleMessage = body.decl((Type)this.ref(MuleMessage.class), "muleMessage", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMuleMessage.class)).arg((GeneratedExpression)response).arg(ExpressionFactory.direct((String)"muleContext")));
        for (OAuthCallbackParameterField field : module.getCallbackParameters()) {
            GeneratedInvocation invocation = connector.invoke("set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(field.asTypeMirror()), (GeneratedExpression)expressionManager.invoke("evaluate").arg(field.getExpression()).arg((GeneratedExpression)muleMessage)));
            body.add((Statement)invocation);
        }
    }

    private void generateSetCustomPropertiesMethod(Module module, GeneratedClass adapterClass, GeneratedClass oauthManagerClass) {
        GeneratedMethod setCustomPropertiesMethod = oauthManagerClass.method(2, (Type)this.ctx().getCodeModel().VOID, "setCustomProperties");
        setCustomPropertiesMethod.annotate(Override.class);
        GeneratedVariable adapter = setCustomPropertiesMethod.param((Type)this.ref(OAuth2Adapter.class), "adapter");
        GeneratedVariable connector = setCustomPropertiesMethod.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)adapter));
        for (Field field : module.getConfigurableFields()) {
            if (((OAuthModule)module).getConsumerKeyField().equals(field)) {
                setCustomPropertiesMethod.body().add((Statement)connector.invoke("set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getConsumerKey")));
                continue;
            }
            if (((OAuthModule)module).getConsumerSecretField().equals(field)) {
                setCustomPropertiesMethod.body().add((Statement)connector.invoke("set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getConsumerSecret")));
                continue;
            }
            if (((OAuthModule)module).getScopeField() != null && ((OAuthModule)module).getScopeField().equals(field)) {
                setCustomPropertiesMethod.body().add((Statement)connector.invoke("set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getScope")));
                continue;
            }
            setCustomPropertiesMethod.body().add((Statement)connector.invoke("set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)ExpressionFactory.invoke((String)("get" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())))));
        }
    }

    private void generateCreatePoolFactoryMethod(GeneratedClass oauthClientFactoryClass, GeneratedClass oauthManagerClass) {
        GeneratedMethod createPoolFactoryMethod = oauthManagerClass.method(2, (Type)this.ref(KeyedPoolableObjectFactory.class), "createPoolFactory");
        createPoolFactoryMethod.annotate(Override.class);
        GeneratedVariable oauthManager = createPoolFactoryMethod.param((Type)this.ref(OAuth2Manager.class).narrow(OAuth2Adapter.class), "oauthManager");
        GeneratedVariable objectStore = createPoolFactoryMethod.param((Type)this.ref(ObjectStore.class).narrow(Serializable.class), "objectStore");
        createPoolFactoryMethod.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)oauthClientFactoryClass).arg((GeneratedExpression)oauthManager).arg((GeneratedExpression)objectStore));
    }

    private void generateInstantiateMethod(Module module, GeneratedClass oauthManagerClass) {
        GeneratedMethod instantiateMethod = oauthManagerClass.method(2, (Type)this.ref(OAuth2Adapter.class), "instantiateAdapter");
        instantiateMethod.annotate(Override.class);
        if (module.hasRestCalls()) {
            instantiateMethod.body().directStatement("return new " + module.getPackage().getName() + ".adapters." + module.getClassName() + "RestClientAdapter(this);");
        } else {
            GeneratedClass oauthAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module);
            instantiateMethod.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)oauthAdapterClass.topLevelClass()).arg(ExpressionFactory._this()));
        }
    }

    private void generateSetCustomStateProperties(Module module, GeneratedClass oauthClientFactoryClass, GeneratedClass adapterClass, GeneratedClass stateClass) {
        GeneratedMethod setCustomStatePropertiesMethod = oauthClientFactoryClass.method(2, (Type)this.ctx().getCodeModel().VOID, "setCustomStateProperties");
        setCustomStatePropertiesMethod.annotate(Override.class);
        GeneratedVariable adapter = setCustomStatePropertiesMethod.param((Type)this.ref(OAuth2Adapter.class), "adapter");
        GeneratedVariable state = setCustomStatePropertiesMethod.param((Type)this.ref(OAuthState.class), "state");
        GeneratedVariable connector = setCustomStatePropertiesMethod.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)adapter));
        for (OAuthCallbackParameterField field : ((OAuthModule)module).getCallbackParameters()) {
            setCustomStatePropertiesMethod.body().add((Statement)state.invoke("setCustomProperty").arg(field.getName()).arg((GeneratedExpression)connector.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName()))));
        }
    }

    private void generateSetCustomAdapterPropertiesMethod(Module module, GeneratedClass oauthClientFactoryClass, GeneratedClass adapterClass, GeneratedClass stateClass, GeneratedField oauthManager) {
        GeneratedMethod setCustomAdapterPropertiesMethod = oauthClientFactoryClass.method(2, (Type)this.ctx().getCodeModel().VOID, "setCustomAdapterProperties");
        setCustomAdapterPropertiesMethod.annotate(Override.class);
        GeneratedVariable adapter = setCustomAdapterPropertiesMethod.param((Type)this.ref(OAuth2Adapter.class), "adapter");
        GeneratedVariable state = setCustomAdapterPropertiesMethod.param((Type)this.ref(OAuthState.class), "state");
        GeneratedVariable connector = setCustomAdapterPropertiesMethod.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)adapter));
        for (OAuthCallbackParameterField field : ((OAuthModule)module).getCallbackParameters()) {
            setCustomAdapterPropertiesMethod.body().add((Statement)connector.invoke("set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)state.invoke("getCustomProperty").arg(field.getName())));
        }
        for (OAuthCallbackParameterField field : module.getConfigurableFields()) {
            if (((OAuthModule)module).getConsumerKeyField().equals(field) || ((OAuthModule)module).getConsumerSecretField().equals(field)) continue;
            setCustomAdapterPropertiesMethod.body().add((Statement)connector.invoke("set" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)oauthManager.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)field.getName()))));
        }
    }

    private void generateGetAdapterClassMethod(Module module, GeneratedClass oauthClientFactoryClass, GeneratedClass adapterClass) {
        GeneratedMethod getAdapterClassMethod = oauthClientFactoryClass.method(2, (Type)this.ref(Class.class).narrow(this.ref(OAuth2Adapter.class).wildcard()), "getAdapterClass");
        getAdapterClassMethod.annotate(Override.class);
        if (module.hasRestCalls()) {
            getAdapterClassMethod.body()._return(ExpressionFactory.direct((String)(module.getPackage().getName() + ".adapters." + module.getClassName() + "RestClientAdapter.class")));
        } else {
            getAdapterClassMethod.body()._return(adapterClass.dotclass());
        }
    }

    private GeneratedField consumerField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(OAuthConsumer.class).name("consumer").build();
    }

    private void generateOAuthClientFactoryConstructor(GeneratedClass oauthManagerClass, GeneratedClass oauthClientFactoryClass) {
        GeneratedMethod oauthClientFactoryConstructor = oauthClientFactoryClass.constructor(1);
        GeneratedVariable constructorOAuthManager = oauthClientFactoryConstructor.param((Type)this.ref(OAuth2Manager.class).narrow(this.ref(OAuth2Adapter.class)), "oauthManager");
        GeneratedVariable constructorObjectStore = oauthClientFactoryConstructor.param((Type)this.ref(ObjectStore.class).narrow(this.ref(Serializable.class)), "objectStore");
        oauthClientFactoryConstructor.body().directStatement("super(oauthManager, objectStore);");
        oauthClientFactoryConstructor.body().directStatement(String.format("this.oauthManager = (%s) oauthManager;", oauthManagerClass.name()));
    }

    private GeneratedClass getOAuthManagerClass(OAuthModule module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass oauthManagerClass = OAuthVersion.V2.equals((Object)module.getOAuthVersion()) ? pkg._class(module.getClassName() + "OAuthManager", this.ref(BaseOAuth2Manager.class).narrow(OAuth2Adapter.class)) : pkg._class(module.getClassName() + "OAuthManager", this.ref(BaseOAuth1Manager.class));
        this.ctx().registerProduct(Product.OAUTH_MANAGER, (Identifiable)module, (Object)oauthManagerClass);
        oauthManagerClass.javadoc().add((Object)("A {@code " + oauthManagerClass.name() + "} is a wrapper around "));
        oauthManagerClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        oauthManagerClass.javadoc().add((Object)" that adds access token management capabilities to the pojo.");
        return oauthManagerClass;
    }

    private GeneratedClass getOAuthClientFactoryClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass objectFactory = pkg._class(1, module.getClassName() + "OAuthClientFactory");
        objectFactory._extends(this.ref(BaseOAuthClientFactory.class));
        return objectFactory;
    }

    protected void generateMetadataConstantsAndGetters(Module module, GeneratedClass generatedClass) {
        String connectorName = module.getFriendlyName();
        if (StringUtils.isEmpty((String)connectorName)) {
            connectorName = module.getModuleName();
        }
        GeneratedField moduleName = FieldBuilder.newConstantFieldBuilder((GeneratedClass)generatedClass).type(String.class).name("MODULE_NAME").initialValue(connectorName).build();
        GeneratedField moduleVersion = FieldBuilder.newConstantFieldBuilder((GeneratedClass)generatedClass).type(String.class).name("MODULE_VERSION").initialValue(this.ctx().getMavenInformation().getVersion()).build();
        GeneratedField devkitVersion = FieldBuilder.newConstantFieldBuilder((GeneratedClass)generatedClass).type(String.class).name("DEVKIT_VERSION").initialValue(this.ctx().getManifest().getProductVersion()).build();
        GeneratedField devkitBuild = FieldBuilder.newConstantFieldBuilder((GeneratedClass)generatedClass).type(String.class).name("DEVKIT_BUILD").initialValue(this.ctx().getManifest().getBuildNumber()).build();
        this.generateGetter(generatedClass, moduleName, "getModuleName");
        this.generateGetter(generatedClass, moduleVersion, "getModuleVersion");
        this.generateGetter(generatedClass, devkitVersion, "getDevkitVersion");
        this.generateGetter(generatedClass, devkitBuild, "getDevkitBuild");
    }

    private void generateGetter(GeneratedClass metadataAdapter, GeneratedField field, String getterMethodName) {
        GeneratedMethod getter = metadataAdapter.method(1, (Type)this.ref(String.class), getterMethodName);
        getter.body()._return((GeneratedExpression)field);
    }
}

