/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.process;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.UnableToAcquireConnectionException;
import org.mule.api.UnableToReleaseConnectionException;
import org.mule.api.oauth.OAuthManager;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;

@JustOnce
public class ManagedAccessTokenProcessInterceptorGenerator
extends AbstractOAuthAdapterGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CONNECTION_KEY, Product.OAUTH_ADAPTER, Product.ABSTRACT_EXPRESSION_EVALUATOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MANAGED_ACCESS_TOKEN_PROCESS_INTERCEPTOR);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() != null;
    }

    public void generate(Module module) throws GenerationException {
        OAuthModule oauthModule = (OAuthModule)module;
        GeneratedClass oauthAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module);
        GeneratedClass managedAccessTokenProcessInterceptorClass = this.getManagedAccessTokenProcessInterceptorClass(oauthModule);
        TypeVariable t = managedAccessTokenProcessInterceptorClass.generify("T");
        managedAccessTokenProcessInterceptorClass._implements(this.ref(ProcessInterceptor.class).narrow((TypeReference)t).narrow((TypeReference)oauthAdapterClass));
        GeneratedField logger = this.generateLoggerField(managedAccessTokenProcessInterceptorClass);
        GeneratedField connectionManager = this.generateOAuthManagedField(oauthAdapterClass, managedAccessTokenProcessInterceptorClass);
        GeneratedField muleContext = managedAccessTokenProcessInterceptorClass.field(12, (Type)this.ref(MuleContext.class), "muleContext");
        GeneratedField next = managedAccessTokenProcessInterceptorClass.field(12, (Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)t).narrow((TypeReference)oauthAdapterClass), "next");
        this.generateConstructor(managedAccessTokenProcessInterceptorClass, oauthModule, next, connectionManager, muleContext);
        this.generateExecuteMethod(oauthModule, oauthAdapterClass, managedAccessTokenProcessInterceptorClass, t, logger, connectionManager, next, muleContext);
        this.generateExecuteMethodForMessage(oauthModule, oauthAdapterClass, managedAccessTokenProcessInterceptorClass, t, logger, connectionManager, next, muleContext);
    }

    private void generateExecuteMethod(OAuthModule oauthModule, GeneratedClass oauthAdapterClass, GeneratedClass managedAccessTokenProcessInterceptorClass, TypeVariable t, GeneratedField logger, GeneratedField connectionManager, GeneratedField next, GeneratedField muleContext) {
        GeneratedMethod execute = managedAccessTokenProcessInterceptorClass.method(1, (Type)t, "execute");
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)t).narrow((TypeReference)oauthAdapterClass), "processCallback");
        GeneratedVariable object = execute.param((Type)oauthAdapterClass, "object");
        GeneratedVariable messageProcessor = execute.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = execute.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedVariable connector = execute.body().decl((Type)oauthAdapterClass, "connector", ExpressionFactory._null());
        GeneratedClass abstractConnectedProcessor = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_CONNECTED_PROCESSOR);
        execute.body()._if(Op.not((GeneratedExpression)processCallback.invoke("isProtected")))._then()._return((GeneratedExpression)processCallback.invoke("process").arg((GeneratedExpression)connectionManager.invoke("getDefaultUnauthorizedConnector")));
        execute.body()._if(ExpressionFactory.cast((Type)abstractConnectedProcessor, (GeneratedExpression)messageProcessor).invoke("getAccessTokenId").isNull())._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(IllegalArgumentException.class)).arg("The accessTokenId cannot be null"));
        GeneratedInvocation getGenericType = abstractConnectedProcessor.dotclass().invoke("getDeclaredField").arg(ExpressionFactory.lit((String)"_accessTokenIdType")).invoke("getGenericType");
        GeneratedInvocation evaluateAndTransform = ExpressionFactory.invoke((String)"evaluateAndTransform").arg((GeneratedExpression)muleContext).arg((GeneratedExpression)event).arg((GeneratedExpression)getGenericType).arg(ExpressionFactory._null()).arg((GeneratedExpression)ExpressionFactory.cast((Type)abstractConnectedProcessor, (GeneratedExpression)messageProcessor).invoke("getAccessTokenId"));
        GeneratedVariable tokenId = execute.body().decl((Type)this.ref(String.class), "_transformedToken", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)evaluateAndTransform));
        GeneratedTry tryCatch = execute.body()._try();
        tryCatch.body()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"Attempting to acquire access token using from store for [accessTokenId="), (GeneratedExpression)tokenId.invoke("toString"))));
        tryCatch.body().assign((AssignmentTarget)connector, (GeneratedExpression)connectionManager.invoke("acquireAccessToken").arg((GeneratedExpression)tokenId));
        GeneratedConditional isConnectionNull = tryCatch.body()._if(connector.isNull());
        isConnectionNull._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnableToAcquireConnectionException.class)));
        isConnectionNull._else()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"Access token has been acquired for [accessTokenId="), (GeneratedExpression)connector.invoke(oauthModule.getUserIdentifierMethod().getName())), (GeneratedExpression)ExpressionFactory.lit((String)"]"))));
        tryCatch.body()._return((GeneratedExpression)next.invoke("execute").arg((GeneratedExpression)processCallback).arg((GeneratedExpression)connector).arg((GeneratedExpression)messageProcessor).arg((GeneratedExpression)event));
        GeneratedCatchBlock catchBlock = tryCatch._catch(this.ref(Exception.class));
        GeneratedVariable e = catchBlock.param("e");
        GeneratedForEach forEachException = catchBlock.body()._if(Op.cand((GeneratedExpression)processCallback.invoke("getManagedExceptions").isNotNull(), (GeneratedExpression)connector.isNotNull()))._then().forEach((Type)this.ref(Class.class), "exceptionClass", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(Class.class), (GeneratedExpression)processCallback.invoke("getManagedExceptions")));
        GeneratedConditional ifIsInstance = forEachException.body()._if((GeneratedExpression)forEachException.var().invoke("isInstance").arg((GeneratedExpression)e));
        ifIsInstance._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"An exception ( "), (GeneratedExpression)forEachException.var().invoke("getName")), (GeneratedExpression)ExpressionFactory.lit((String)") has been thrown. Destroying the access token with [accessTokenId=")), (GeneratedExpression)connector.invoke(oauthModule.getUserIdentifierMethod().getName())), (GeneratedExpression)ExpressionFactory.lit((String)"]"))));
        GeneratedTry tryToDestroy = ifIsInstance._then()._try();
        tryToDestroy.body().add((Statement)connectionManager.invoke("destroyAccessToken").arg((GeneratedExpression)tokenId).arg((GeneratedExpression)connector));
        tryToDestroy.body().assign((AssignmentTarget)connector, ExpressionFactory._null());
        GeneratedCatchBlock releaseCatch = tryToDestroy._catch(this.ref(Exception.class));
        GeneratedVariable innerException = releaseCatch.param("innerException");
        releaseCatch.body().add((Statement)logger.invoke("error").arg((GeneratedExpression)innerException.invoke("getMessage")).arg((GeneratedExpression)innerException));
        catchBlock.body()._throw((GeneratedExpression)e);
        GeneratedTry tryToRelease = tryCatch._finally()._try();
        GeneratedConditional connectionIsNotNull = tryToRelease.body()._if(connector.isNotNull());
        connectionIsNotNull._then()._if((GeneratedExpression)logger.invoke("isDebugEnabled"))._then().add((Statement)logger.invoke("debug").arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"Releasing the access token back into the pool [accessTokenId="), (GeneratedExpression)connector.invoke(oauthModule.getUserIdentifierMethod().getName())), (GeneratedExpression)ExpressionFactory.lit((String)"]"))));
        connectionIsNotNull._then().add((Statement)connectionManager.invoke("releaseAccessToken").arg((GeneratedExpression)tokenId).arg((GeneratedExpression)connector));
        GeneratedCatchBlock catchException = tryToRelease._catch(this.ref(Exception.class));
        GeneratedVariable exception = catchException.param("e");
        catchException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnableToReleaseConnectionException.class)).arg((GeneratedExpression)exception));
    }

    private void generateExecuteMethodForMessage(OAuthModule oauthModule, GeneratedClass oauthAdapterClass, GeneratedClass managedAccessTokenProcessInterceptorClass, TypeVariable t, GeneratedField logger, GeneratedField connectionManager, GeneratedField next, GeneratedField muleContext) {
        GeneratedMethod execute = managedAccessTokenProcessInterceptorClass.method(1, (Type)t, "execute");
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)t).narrow((TypeReference)oauthAdapterClass), "processCallback");
        GeneratedVariable object = execute.param((Type)oauthAdapterClass, "object");
        GeneratedVariable filter = execute.param((Type)this.ref(Filter.class), "filter");
        GeneratedVariable message = execute.param((Type)this.ref(MuleMessage.class), "message");
        execute.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnsupportedOperationException.class)));
    }

    private void generateConstructor(GeneratedClass managedAccessTokenProcessInterceptorClass, OAuthModule module, GeneratedField nextField, GeneratedField oauthManagerField, GeneratedField muleContextField) {
        GeneratedClass oauthAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module);
        GeneratedMethod constructor = managedAccessTokenProcessInterceptorClass.constructor(1);
        GeneratedVariable next = constructor.param((Type)this.ref(ProcessInterceptor.class).narrow((TypeReference)managedAccessTokenProcessInterceptorClass.typeParams()[0]).narrow((TypeReference)oauthAdapterClass), "next");
        GeneratedVariable oauthManager = constructor.param((Type)this.ref(OAuthManager.class).narrow((TypeReference)oauthAdapterClass), "oauthManager");
        GeneratedVariable muleContext = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)nextField), (GeneratedExpression)next);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)oauthManagerField), (GeneratedExpression)oauthManager);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)muleContextField), (GeneratedExpression)muleContext);
    }

    private GeneratedClass getManagedAccessTokenProcessInterceptorClass(OAuthModule type) {
        GeneratedClass abstractExpressionEvaluatorClass = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_EXPRESSION_EVALUATOR);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(type.getPackage().getName() + ".oauth");
        GeneratedClass clazz = pkg._class(1, "ManagedAccessTokenProcessInterceptor");
        clazz._extends((TypeReference)abstractExpressionEvaluatorClass);
        this.ctx().registerProduct(Product.MANAGED_ACCESS_TOKEN_PROCESS_INTERCEPTOR, (Object)clazz);
        return clazz;
    }

    private GeneratedField generateOAuthManagedField(GeneratedClass oauthAdapterClass, GeneratedClass processTemplateClass) {
        return processTemplateClass.field(12, (Type)this.ref(OAuthManager.class).narrow((TypeReference)oauthAdapterClass), "oauthManager");
    }
}

