/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.license;

import com.google.common.base.Optional;
import org.mule.api.annotations.licensing.RequiresEnterpriseLicense;
import org.mule.api.annotations.licensing.RequiresEntitlement;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.internal.lic.LicenseValidatorFactory;
import org.mule.devkit.internal.lic.model.Entitlement;
import org.mule.devkit.internal.lic.validator.LicenseValidator;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

public class LicenseCheckerGenerator {
    private Module module;
    private Context context;
    private Optional<RequiresEntitlement> requiresEntitlement;
    private Optional<RequiresEnterpriseLicense> requiresEnterpriseLicense;

    public LicenseCheckerGenerator(Context context, Module module) {
        this.module = module;
        this.context = context;
        this.requiresEntitlement = module.getRequiresEntitlement();
        this.requiresEnterpriseLicense = module.getRequiresEnterpriseLicense();
    }

    public static boolean requiresLicense(Module element) {
        return (LicenseCheckerGenerator.requiresEntitlement(element) || LicenseCheckerGenerator.requiresEnterpriseLicense(element)) && element.manager().wsdlProviderComponent().isEmpty();
    }

    private static boolean requiresEnterpriseLicense(Module element) {
        return element.getRequiresEnterpriseLicense().isPresent();
    }

    private static boolean requiresEntitlement(Module element) {
        return element.getRequiresEntitlement().isPresent();
    }

    public TypeReference ref(Class<?> clazz) {
        return this.context.getCodeModel().ref(clazz);
    }

    public LicenseCheckerGenerator addTo(GeneratedClass messageProcessorClass) {
        GeneratedMethod checkMuleLicense = messageProcessorClass.method(4, (Type)this.context.getCodeModel().VOID, "checkMuleLicense");
        checkMuleLicense.javadoc().add((Object)"Obtains the expression manager from the Mule context and initialises the connector. If a target object ");
        checkMuleLicense.javadoc().add((Object)" has not been set already it will search the Mule registry for a default one.");
        checkMuleLicense.javadoc().addThrows(this.context.getCodeModel().ref(InitialisationException.class));
        GeneratedVariable validator = checkMuleLicense.body().decl((Type)this.ref(LicenseValidator.class), "licenseValidator", (GeneratedExpression)this.ref(LicenseValidatorFactory.class).staticInvoke("getValidator").arg(this.module.getFriendlyName()));
        checkMuleLicense.body().invoke((GeneratedExpression)validator, "checkEnterpriseLicense").arg(this.allowsEvaluation() ? ExpressionFactory.TRUE : ExpressionFactory.FALSE);
        if (this.requiresEntitlement.isPresent()) {
            GeneratedInvocation entitlement = ExpressionFactory._new((TypeReference)this.ref(Entitlement.class)).arg(((RequiresEntitlement)this.requiresEntitlement.get()).name()).arg(((RequiresEntitlement)this.requiresEntitlement.get()).description()).arg(((RequiresEntitlement)this.requiresEntitlement.get()).provider()).arg(this.module.getModuleName()).arg(this.context.getMavenInformation().getVersion());
            checkMuleLicense.body().invoke((GeneratedExpression)validator, "checkEntitlement").arg((GeneratedExpression)entitlement);
        }
        return this;
    }

    public void into(GeneratedMethod method) {
        method.body().invoke("checkMuleLicense");
    }

    private boolean allowsEvaluation() {
        return this.requiresEnterpriseLicense.isPresent() && ((RequiresEnterpriseLicense)this.requiresEnterpriseLicense.get()).allowEval();
    }
}

