/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.license;

import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.Plugin;
import org.mule.devkit.generation.api.PostProcessor;
import org.mule.devkit.generation.api.annotations.Dependency;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


@RequiresMavenDependencies({
        @Dependency(groupId = "com.mulesoft.licm", artifactId = "licm", version = "[1.1.4]")
})
public class LicenseManagerPlugin implements Plugin {
    private List<Generator> moduleGenerators;

    public LicenseManagerPlugin() {
        moduleGenerators = new ArrayList<Generator>();
        moduleGenerators.add(new CheckLicenseAdapterGenerator());
    }

    @Override
    public String getOptionName() {
        return null;
    }

    @Override
    public List<ModuleAnnotationVerifier> getVerifiers() {
        return Collections.emptyList();
    }

    @Override
    public List<Generator> getGenerators() {
        return moduleGenerators;
    }

    @Override
    public List<PostProcessor> getPostProcessors() {
        return Collections.emptyList();
    }
}
