/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.license;

import com.mulesource.licm.EnterpriseLicenseKey;
import com.mulesource.licm.LicenseKeyException;
import com.mulesource.licm.LicenseManagementFactory;
import com.mulesource.licm.LicenseManager;
import com.mulesource.licm.feature.Feature;
import com.mulesource.licm.feature.FeatureValidator;
import de.schlichtherle.license.LicenseContentException;
import java.util.Calendar;
import java.util.Date;
import org.mule.api.annotations.licensing.RequiresEnterpriseLicense;
import org.mule.api.annotations.licensing.RequiresEntitlement;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

public class LicenseCheckerGenerator {
    private Context context;
    private RequiresEntitlement requiresEntitlement;
    private RequiresEnterpriseLicense requiresEnterpriseLicense;

    public LicenseCheckerGenerator(Context context, Module element) {
        this.context = context;
        this.requiresEntitlement = (RequiresEntitlement)element.getAnnotation(RequiresEntitlement.class);
        this.requiresEnterpriseLicense = (RequiresEnterpriseLicense)element.getAnnotation(RequiresEnterpriseLicense.class);
    }

    public static boolean requiresLicense(Module element) {
        return element.getAnnotation(RequiresEntitlement.class) != null || element.getAnnotation(RequiresEnterpriseLicense.class) != null;
    }

    public TypeReference ref(Class<?> clazz) {
        return this.context.getCodeModel().ref(clazz);
    }

    public LicenseCheckerGenerator addTo(GeneratedClass messageProcessorClass) {
        GeneratedMethod checkMuleLicense = messageProcessorClass.method(4, (Type)this.context.getCodeModel().VOID, "checkMuleLicense");
        checkMuleLicense.javadoc().add((Object)"Obtains the expression manager from the Mule context and initialises the connector. If a target object ");
        checkMuleLicense.javadoc().add((Object)" has not been set already it will search the Mule registry for a default one.");
        checkMuleLicense.javadoc().addThrows(this.context.getCodeModel().ref(InitialisationException.class));
        GeneratedTry tryStatement = checkMuleLicense.body()._try();
        GeneratedVariable licenseManager = tryStatement.body().decl((Type)this.ref(LicenseManager.class), "licenseManager", (GeneratedExpression)this.ref(LicenseManagementFactory.class).staticInvoke("getInstance").invoke("createLicenseManager").arg((GeneratedExpression)this.ref(LicenseManagementFactory.class).staticRef("MULE_EE")));
        GeneratedVariable license = tryStatement.body().decl((Type)this.ref(EnterpriseLicenseKey.class), "license", (GeneratedExpression)licenseManager.invoke("validate").arg((GeneratedExpression)this.ref(LicenseManagementFactory.class).staticRef("MULE_EE")));
        this.checkExpirationDate(tryStatement, license);
        if (this.allowsEvaluation()) {
            tryStatement.body()._if((GeneratedExpression)license.invoke("isEvaluation"))._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("This Module does not allow Evaluation Licenses."));
        }
        if (this.requiresEntitlement != null) {
            GeneratedVariable feature = tryStatement.body().decl((Type)this.ref(Feature.class), "feature", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Feature.class)).arg(this.requiresEntitlement.name()).arg(this.requiresEntitlement.description()));
            tryStatement.body().add((Statement)ExpressionFactory._new((TypeReference)this.ref(FeatureValidator.class)).arg((GeneratedExpression)feature).invoke("validate").arg((GeneratedExpression)license));
            GeneratedCatchBlock catchBlock = tryStatement._catch(this.ref(LicenseContentException.class));
            catchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("This module requires " + this.requiresEntitlement.name() + " entitlement in your license"));
        }
        GeneratedCatchBlock catchBlock = tryStatement._catch(this.ref(LicenseKeyException.class));
        catchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("This Module requires an Enterprise license"));
        return this;
    }

    private void checkExpirationDate(GeneratedTry tryStatement, GeneratedVariable license) {
        GeneratedVariable expirationDate = tryStatement.body().decl((Type)this.ref(Calendar.class), "expirationDate", (GeneratedExpression)this.ref(Calendar.class).staticInvoke("getInstance"));
        GeneratedConditional ifExpirationDateNotNull = tryStatement.body()._if(expirationDate.isNotNull());
        ifExpirationDateNotNull._then().add((Statement)expirationDate.invoke("setTime").arg((GeneratedExpression)license.invoke("getExpirationDate")));
        ifExpirationDateNotNull._then()._if((GeneratedExpression)expirationDate.invoke("after").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Date.class))))._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Your license has expire"));
    }

    public void into(GeneratedMethod method) {
        method.body().invoke("checkMuleLicense");
    }

    private boolean allowsEvaluation() {
        return this.requiresEnterpriseLicense != null && !this.requiresEnterpriseLicense.allowEval();
    }
}

