/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.expressionlanguage;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

import javax.lang.model.type.TypeMirror;

public abstract class AbstractExpressionLanguageGenerator implements ModuleGenerator {

    protected Context context;

    public Context ctx() {
        return context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    protected TypeReference ref(Class<?> clazz) {
        return ctx().getCodeModel().ref(clazz);
    }

    protected org.mule.devkit.model.code.Type ref(TypeMirror typeMirror) {
        return ctx().getCodeModel().ref(typeMirror);
    }

    protected org.mule.devkit.model.code.Type ref(Module module) {
        return ctx().getCodeModel().ref(module.asTypeMirror());
    }
}
