/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.expressionlanguage;

import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.Plugin;
import org.mule.devkit.generation.api.PostProcessor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExpressionLanguagePlugin implements Plugin {
    private List<ModuleAnnotationVerifier> annotationVerifiers;
    private List<Generator> moduleGenerators;

    public ExpressionLanguagePlugin() {
        moduleGenerators = new ArrayList<Generator>();

        annotationVerifiers = new ArrayList<ModuleAnnotationVerifier>();
        annotationVerifiers.add(new ExpressionLanguageAnnotationVerifier());

        moduleGenerators = new ArrayList<Generator>();
        moduleGenerators.add(new ExpressionEnricherGenerator());
        moduleGenerators.add(new ExpressionEvaluatorGenerator());
    }

    @Override
    public String getOptionName() {
        return null;
    }

    @Override
    public List<ModuleAnnotationVerifier> getVerifiers() {
        return annotationVerifiers;
    }

    @Override
    public List<Generator> getGenerators() {
        return moduleGenerators;
    }

    @Override
    public List<PostProcessor> getPostProcessors() {
        return Collections.emptyList();
    }
}
