/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.atgenerated;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Generated;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.atgenerated.AbstractAtGeneratedGenerator;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtGeneratedGenerator
extends AbstractAtGeneratedGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.SCHEMA);
    private static final List<Product> PRODUCES = Arrays.asList(new Product[0]);
    private String date = null;

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        TypeReference atGeneratedAnnotation = this.ref(Generated.class);
        Iterator packageIterator = this.ctx().getCodeModel().packages();
        while (packageIterator.hasNext()) {
            GeneratedPackage pkg = (GeneratedPackage)packageIterator.next();
            Iterator classesIterator = pkg.classes();
            while (classesIterator.hasNext()) {
                GeneratedClass clazz = (GeneratedClass)classesIterator.next();
                boolean found = false;
                for (GeneratedAnnotationUse use : clazz.annotations()) {
                    if (!use.getAnnotationClass().name().equals(atGeneratedAnnotation.name())) continue;
                    found = true;
                }
                if (found) continue;
                clazz.annotate(atGeneratedAnnotation).param("value", "Mule DevKit Version " + this.ctx().getManifest().getProductVersion()).param("date", this.getISO8601Date()).param("comments", "Build " + this.ctx().getManifest().getBuildNumber());
            }
        }
    }

    private String getISO8601Date() {
        if (this.date == null) {
            StringBuffer tstamp = new StringBuffer();
            tstamp.append(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssZ").format(new Date()));
            tstamp.insert(tstamp.length() - 2, ':');
            this.date = tstamp.toString();
        }
        return this.date;
    }
}

