/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.nexus.task;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;
import org.sonatype.scheduling.SchedulerTask;

@Named(value="devkit.indexer.task")
public class DevkitReIndexerTask
extends AbstractNexusRepositoriesTask<Object>
implements SchedulerTask<Object> {
    private IndexerManager indexerManager;
    private RepositoryRegistry repositories;

    @Inject
    public DevkitReIndexerTask(IndexerManager indexerManager, RepositoryRegistry repositories) {
        this.indexerManager = indexerManager;
        this.repositories = repositories;
    }

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    protected String getAction() {
        return "REINDEX";
    }

    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return String.format("Reindexing Devkit modules repository on repository [%s] from root path and bellow", this.getRepositoryId());
        }
        return "Reindex all modules)";
    }

    protected Object doRun() throws Exception {
        String repositoryId = this.getRepositoryId();
        this.logger.debug("Reindexing Devkit on repository [{}]", (Object)repositoryId);
        try {
            Repository repository = this.repositories.getRepository(repositoryId);
            this.indexerManager.reindexRepository(null, repository.getId(), true);
        }
        catch (Exception e) {
            this.logger.warn(String.format("Reindexing devkit modules not executed as repository [%s] could not be scanned due to [%s]", repositoryId, e.getMessage()), (Throwable)e);
        }
        return null;
    }
}

