/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.nexus;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.lucene.search.Query;
import org.apache.maven.index.AndMultiArtifactInfoFilter;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.util.StringUtils;
import org.mule.devkit.nexus.capabilities.DevkitNexusCapability;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StringContentLocator;

public class PluginCatalogContentLocator
implements ContentLocator {
    private final IndexingContext indexingContext;
    private final ArtifactInfoFilter artifactInfoFilter;
    private final NexusIndexer nexusIndexer;

    public PluginCatalogContentLocator(IndexingContext indexingContext, NexusIndexer nexusIndexer, ArtifactInfoFilter artifactInfoFilter) {
        this.indexingContext = indexingContext;
        this.nexusIndexer = nexusIndexer;
        this.artifactInfoFilter = artifactInfoFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent() throws IOException {
        Query pq = this.nexusIndexer.constructQuery(DevkitNexusCapability.IS_PLUGIN, Boolean.TRUE.toString(), SearchType.EXACT);
        IteratorSearchRequest sreq = new IteratorSearchRequest(pq, this.indexingContext);
        ClassifierArtifactInfoFilter classifierFilter = new ClassifierArtifactInfoFilter();
        if (this.artifactInfoFilter != null) {
            AndMultiArtifactInfoFilter andArtifactFilter = new AndMultiArtifactInfoFilter(Arrays.asList(classifierFilter, this.artifactInfoFilter));
            sreq.setArtifactInfoFilter((ArtifactInfoFilter)andArtifactFilter);
        } else {
            sreq.setArtifactInfoFilter((ArtifactInfoFilter)classifierFilter);
        }
        IteratorSearchResponse hits = null;
        try {
            hits = this.nexusIndexer.searchIterator(sreq);
            StringWriter sw = new StringWriter();
            sw.append("<plugin-catalog>");
            sw.append("<plugins>");
            for (ArtifactInfo info : hits) {
                sw.append("<plugin>");
                sw.append("<groupId>" + info.groupId + "</groupId>");
                sw.append("<artifactId>" + info.artifactId + "</artifactId>");
                sw.append("<version>" + info.version + "</version>");
                if (info.description != null) {
                    sw.append("<description>" + info.description + "</description>");
                }
                sw.append("</plugin>");
            }
            sw.append("</plugins>");
            sw.append("</plugin-catalog>");
            InputStream inputStream = new StringContentLocator(sw.toString()).getContent();
            return inputStream;
        }
        finally {
            if (hits != null) {
                hits.close();
            }
        }
    }

    public String getMimeType() {
        return "text/xml";
    }

    public boolean isReusable() {
        return true;
    }

    public static class ClassifierArtifactInfoFilter
    implements ArtifactInfoFilter {
        public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
            return StringUtils.isBlank((String)ai.classifier);
        }
    }
}

