package org.mule.devkit.nexus;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

@Component(role = IndexCreator.class, hint = ModuleIndexCreator.ID)
public class ModuleIndexCreator
        extends AbstractIndexCreator implements LogEnabled {
    public static final String ID = "mule-index";

    private Logger logger;

    public static final IndexerField FLD_SCHEMA_VERSION = new IndexerField(Module.SCHEMA_VERSION, IndexerFieldVersion.V3,
            "schemaVersion", "Artifact Mule's Schema Version", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_LOCATION_0 = new IndexerField(Module.SCHEMA_LOCATION_0, IndexerFieldVersion.V3,
            "schemaLocation.0", "Artifact Mule's Schema Location", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_LOCATION_1 = new IndexerField(Module.SCHEMA_LOCATION_1, IndexerFieldVersion.V3,
            "schemaLocation.1", "Artifact Mule's Schema Location", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_LOCATION_2 = new IndexerField(Module.SCHEMA_LOCATION_2, IndexerFieldVersion.V3,
            "schemaLocation.2", "Artifact Mule's Schema Location", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_LOCATION_3 = new IndexerField(Module.SCHEMA_LOCATION_3, IndexerFieldVersion.V3,
            "schemaLocation.3", "Artifact Mule's Schema Location", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_LOCATION_4 = new IndexerField(Module.SCHEMA_LOCATION_4, IndexerFieldVersion.V3,
            "schemaLocation.4", "Artifact Mule's Schema Location", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_LOCATION_5 = new IndexerField(Module.SCHEMA_LOCATION_5, IndexerFieldVersion.V3,
            "schemaLocation.5", "Artifact Mule's Schema Location", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_LOCATION_6 = new IndexerField(Module.SCHEMA_LOCATION_6, IndexerFieldVersion.V3,
            "schemaLocation.6", "Artifact Mule's Schema Location", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_LOCATION_7 = new IndexerField(Module.SCHEMA_LOCATION_7, IndexerFieldVersion.V3,
            "schemaLocation.7", "Artifact Mule's Schema Location", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_LOCATION_8 = new IndexerField(Module.SCHEMA_LOCATION_8, IndexerFieldVersion.V3,
            "schemaLocation.8", "Artifact Mule's Schema Location", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_LOCATION_9 = new IndexerField(Module.SCHEMA_LOCATION_9, IndexerFieldVersion.V3,
            "schemaLocation.9", "Artifact Mule's Schema Location", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_NAMESPACE_0 = new IndexerField(Module.SCHEMA_NAMESPACE_0, IndexerFieldVersion.V3,
            "schemaNamespace.0", "Artifact Mule's Schema Namespace", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_NAMESPACE_1 = new IndexerField(Module.SCHEMA_NAMESPACE_1, IndexerFieldVersion.V3,
            "schemaNamespace.1", "Artifact Mule's Schema Namespace", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_SCHEMA_NAMESPACE_2 = new IndexerField(Module.SCHEMA_NAMESPACE_2, IndexerFieldVersion.V3,
            "schemaNamespace.2", "Artifact Mule's Schema Namespace", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
    public static final IndexerField FLD_SCHEMA_NAMESPACE_3 = new IndexerField(Module.SCHEMA_NAMESPACE_3, IndexerFieldVersion.V3,
            "schemaNamespace.3", "Artifact Mule's Schema Namespace", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
    public static final IndexerField FLD_SCHEMA_NAMESPACE_4 = new IndexerField(Module.SCHEMA_NAMESPACE_4, IndexerFieldVersion.V3,
            "schemaNamespace.4", "Artifact Mule's Schema Namespace", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
    public static final IndexerField FLD_SCHEMA_NAMESPACE_5 = new IndexerField(Module.SCHEMA_NAMESPACE_5, IndexerFieldVersion.V3,
            "schemaNamespace.5", "Artifact Mule's Schema Namespace", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
    public static final IndexerField FLD_SCHEMA_NAMESPACE_6 = new IndexerField(Module.SCHEMA_NAMESPACE_6, IndexerFieldVersion.V3,
            "schemaNamespace.6", "Artifact Mule's Schema Namespace", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
    public static final IndexerField FLD_SCHEMA_NAMESPACE_7 = new IndexerField(Module.SCHEMA_NAMESPACE_7, IndexerFieldVersion.V3,
            "schemaNamespace.7", "Artifact Mule's Schema Namespace", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
    public static final IndexerField FLD_SCHEMA_NAMESPACE_8 = new IndexerField(Module.SCHEMA_NAMESPACE_8, IndexerFieldVersion.V3,
            "schemaNamespace.8", "Artifact Mule's Schema Namespace", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
    public static final IndexerField FLD_SCHEMA_NAMESPACE_9 = new IndexerField(Module.SCHEMA_NAMESPACE_9, IndexerFieldVersion.V3,
            "schemaNamespace.9", "Artifact Mule's Schema Namespace", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
    public static final IndexerField FLD_SCHEMA_CONTENT_0 = new IndexerField(Module.SCHEMA_CONTENT_0, IndexerFieldVersion.V3,
            "schemaContent.0", "Artifact Mule's Schema Content", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_SCHEMA_CONTENT_1 = new IndexerField(Module.SCHEMA_CONTENT_1, IndexerFieldVersion.V3,
            "schemaContent.1", "Artifact Mule's Schema Content", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_SCHEMA_CONTENT_2 = new IndexerField(Module.SCHEMA_CONTENT_2, IndexerFieldVersion.V3,
            "schemaContent.2", "Artifact Mule's Schema Content", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_SCHEMA_CONTENT_3 = new IndexerField(Module.SCHEMA_CONTENT_3, IndexerFieldVersion.V3,
            "schemaContent.3", "Artifact Mule's Schema Content", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_SCHEMA_CONTENT_4 = new IndexerField(Module.SCHEMA_CONTENT_4, IndexerFieldVersion.V3,
            "schemaContent.4", "Artifact Mule's Schema Content", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_SCHEMA_CONTENT_5 = new IndexerField(Module.SCHEMA_CONTENT_5, IndexerFieldVersion.V3,
            "schemaContent.5", "Artifact Mule's Schema Content", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_SCHEMA_CONTENT_6 = new IndexerField(Module.SCHEMA_CONTENT_6, IndexerFieldVersion.V3,
            "schemaContent.6", "Artifact Mule's Schema Content", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_SCHEMA_CONTENT_7 = new IndexerField(Module.SCHEMA_CONTENT_7, IndexerFieldVersion.V3,
            "schemaContent.7", "Artifact Mule's Schema Content", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_SCHEMA_CONTENT_8 = new IndexerField(Module.SCHEMA_CONTENT_8, IndexerFieldVersion.V3,
            "schemaContent.8", "Artifact Mule's Schema Content", Field.Store.YES, Field.Index.NO);
    public static final IndexerField FLD_SCHEMA_CONTENT_9 = new IndexerField(Module.SCHEMA_CONTENT_9, IndexerFieldVersion.V3,
            "schemaContent.9", "Artifact Mule's Schema Content", Field.Store.YES, Field.Index.NO);

    public ModuleIndexCreator() {
        super(ID);
    }

    public void enableLogging(final Logger logger) {
        this.logger = logger;
    }

    public void populateArtifactInfo(ArtifactContext artifactContext)
            throws IOException {
        ArtifactInfo ai = artifactContext.getArtifactInfo();

        File artifactFile = artifactContext.getArtifact();

        if (artifactFile != null && artifactFile.exists() &&
                (artifactFile.getName().endsWith(".jar") || artifactFile.getName().endsWith(".zip"))) {
            updateArtifactInfo(ai, artifactFile);
        }
    }

    public void updateDocument(ArtifactInfo ai, Document doc) {
        if (ai.getAttributes().containsKey(FLD_SCHEMA_VERSION.getKey())) {
            doc.add(FLD_SCHEMA_VERSION.toField(ai.getAttributes().get(FLD_SCHEMA_VERSION.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_LOCATION_0.getKey())) {
            doc.add(FLD_SCHEMA_LOCATION_0.toField(ai.getAttributes().get(FLD_SCHEMA_LOCATION_0.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_LOCATION_1.getKey())) {
            doc.add(FLD_SCHEMA_LOCATION_1.toField(ai.getAttributes().get(FLD_SCHEMA_LOCATION_1.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_LOCATION_2.getKey())) {
            doc.add(FLD_SCHEMA_LOCATION_2.toField(ai.getAttributes().get(FLD_SCHEMA_LOCATION_2.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_LOCATION_3.getKey())) {
            doc.add(FLD_SCHEMA_LOCATION_3.toField(ai.getAttributes().get(FLD_SCHEMA_LOCATION_3.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_LOCATION_4.getKey())) {
            doc.add(FLD_SCHEMA_LOCATION_4.toField(ai.getAttributes().get(FLD_SCHEMA_LOCATION_4.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_LOCATION_5.getKey())) {
            doc.add(FLD_SCHEMA_LOCATION_5.toField(ai.getAttributes().get(FLD_SCHEMA_LOCATION_5.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_LOCATION_6.getKey())) {
            doc.add(FLD_SCHEMA_LOCATION_6.toField(ai.getAttributes().get(FLD_SCHEMA_LOCATION_6.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_LOCATION_7.getKey())) {
            doc.add(FLD_SCHEMA_LOCATION_7.toField(ai.getAttributes().get(FLD_SCHEMA_LOCATION_7.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_LOCATION_8.getKey())) {
            doc.add(FLD_SCHEMA_LOCATION_8.toField(ai.getAttributes().get(FLD_SCHEMA_LOCATION_8.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_LOCATION_9.getKey())) {
            doc.add(FLD_SCHEMA_LOCATION_9.toField(ai.getAttributes().get(FLD_SCHEMA_LOCATION_9.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_0.getKey())) {
            doc.add(FLD_SCHEMA_NAMESPACE_0.toField(ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_0.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_1.getKey())) {
            doc.add(FLD_SCHEMA_NAMESPACE_1.toField(ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_1.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_2.getKey())) {
            doc.add(FLD_SCHEMA_NAMESPACE_2.toField(ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_2.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_3.getKey())) {
            doc.add(FLD_SCHEMA_NAMESPACE_3.toField(ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_3.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_4.getKey())) {
            doc.add(FLD_SCHEMA_NAMESPACE_4.toField(ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_4.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_5.getKey())) {
            doc.add(FLD_SCHEMA_NAMESPACE_5.toField(ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_5.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_6.getKey())) {
            doc.add(FLD_SCHEMA_NAMESPACE_6.toField(ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_6.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_7.getKey())) {
            doc.add(FLD_SCHEMA_NAMESPACE_7.toField(ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_7.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_8.getKey())) {
            doc.add(FLD_SCHEMA_NAMESPACE_8.toField(ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_8.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_9.getKey())) {
            doc.add(FLD_SCHEMA_NAMESPACE_9.toField(ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_9.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_CONTENT_0.getKey())) {
            doc.add(FLD_SCHEMA_CONTENT_0.toField(ai.getAttributes().get(FLD_SCHEMA_CONTENT_0.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_CONTENT_1.getKey())) {
            doc.add(FLD_SCHEMA_CONTENT_1.toField(ai.getAttributes().get(FLD_SCHEMA_CONTENT_1.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_CONTENT_2.getKey())) {
            doc.add(FLD_SCHEMA_CONTENT_2.toField(ai.getAttributes().get(FLD_SCHEMA_CONTENT_2.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_CONTENT_3.getKey())) {
            doc.add(FLD_SCHEMA_CONTENT_3.toField(ai.getAttributes().get(FLD_SCHEMA_CONTENT_3.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_CONTENT_4.getKey())) {
            doc.add(FLD_SCHEMA_CONTENT_4.toField(ai.getAttributes().get(FLD_SCHEMA_CONTENT_4.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_CONTENT_5.getKey())) {
            doc.add(FLD_SCHEMA_CONTENT_5.toField(ai.getAttributes().get(FLD_SCHEMA_CONTENT_5.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_CONTENT_6.getKey())) {
            doc.add(FLD_SCHEMA_CONTENT_6.toField(ai.getAttributes().get(FLD_SCHEMA_CONTENT_6.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_CONTENT_7.getKey())) {
            doc.add(FLD_SCHEMA_CONTENT_7.toField(ai.getAttributes().get(FLD_SCHEMA_CONTENT_7.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_CONTENT_8.getKey())) {
            doc.add(FLD_SCHEMA_CONTENT_8.toField(ai.getAttributes().get(FLD_SCHEMA_CONTENT_8.getKey())));
        }
        if (ai.getAttributes().containsKey(FLD_SCHEMA_CONTENT_9.getKey())) {
            doc.add(FLD_SCHEMA_CONTENT_9.toField(ai.getAttributes().get(FLD_SCHEMA_CONTENT_9.getKey())));
        }
    }

    public boolean updateArtifactInfo(Document doc, ArtifactInfo artifactInfo) {
        int i = 0;
        if (doc.get(FLD_SCHEMA_LOCATION_0.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_LOCATION_0.getKey(), doc.get(FLD_SCHEMA_LOCATION_0.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_LOCATION_1.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_LOCATION_1.getKey(), doc.get(FLD_SCHEMA_LOCATION_1.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_LOCATION_2.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_LOCATION_2.getKey(), doc.get(FLD_SCHEMA_LOCATION_2.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_LOCATION_3.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_LOCATION_3.getKey(), doc.get(FLD_SCHEMA_LOCATION_3.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_LOCATION_4.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_LOCATION_4.getKey(), doc.get(FLD_SCHEMA_LOCATION_4.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_LOCATION_5.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_LOCATION_5.getKey(), doc.get(FLD_SCHEMA_LOCATION_5.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_LOCATION_6.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_LOCATION_6.getKey(), doc.get(FLD_SCHEMA_LOCATION_6.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_LOCATION_7.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_LOCATION_7.getKey(), doc.get(FLD_SCHEMA_LOCATION_7.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_LOCATION_8.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_LOCATION_8.getKey(), doc.get(FLD_SCHEMA_LOCATION_8.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_LOCATION_9.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_LOCATION_9.getKey(), doc.get(FLD_SCHEMA_LOCATION_9.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_VERSION.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_VERSION.getKey(), doc.get(FLD_SCHEMA_VERSION.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_NAMESPACE_0.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_NAMESPACE_0.getKey(), doc.get(FLD_SCHEMA_NAMESPACE_0.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_NAMESPACE_1.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_NAMESPACE_1.getKey(), doc.get(FLD_SCHEMA_NAMESPACE_1.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_NAMESPACE_2.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_NAMESPACE_2.getKey(), doc.get(FLD_SCHEMA_NAMESPACE_2.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_NAMESPACE_3.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_NAMESPACE_3.getKey(), doc.get(FLD_SCHEMA_NAMESPACE_3.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_NAMESPACE_4.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_NAMESPACE_4.getKey(), doc.get(FLD_SCHEMA_NAMESPACE_4.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_NAMESPACE_5.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_NAMESPACE_5.getKey(), doc.get(FLD_SCHEMA_NAMESPACE_5.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_NAMESPACE_6.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_NAMESPACE_6.getKey(), doc.get(FLD_SCHEMA_NAMESPACE_6.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_NAMESPACE_7.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_NAMESPACE_7.getKey(), doc.get(FLD_SCHEMA_NAMESPACE_7.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_NAMESPACE_8.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_NAMESPACE_8.getKey(), doc.get(FLD_SCHEMA_NAMESPACE_8.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_NAMESPACE_9.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_NAMESPACE_9.getKey(), doc.get(FLD_SCHEMA_NAMESPACE_9.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_CONTENT_0.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_CONTENT_0.getKey(), doc.get(FLD_SCHEMA_CONTENT_0.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_CONTENT_1.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_CONTENT_1.getKey(), doc.get(FLD_SCHEMA_CONTENT_1.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_CONTENT_2.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_CONTENT_2.getKey(), doc.get(FLD_SCHEMA_CONTENT_2.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_CONTENT_3.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_CONTENT_3.getKey(), doc.get(FLD_SCHEMA_CONTENT_3.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_CONTENT_4.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_CONTENT_4.getKey(), doc.get(FLD_SCHEMA_CONTENT_4.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_CONTENT_5.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_CONTENT_5.getKey(), doc.get(FLD_SCHEMA_CONTENT_5.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_CONTENT_6.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_CONTENT_6.getKey(), doc.get(FLD_SCHEMA_CONTENT_6.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_CONTENT_7.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_CONTENT_7.getKey(), doc.get(FLD_SCHEMA_CONTENT_7.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_CONTENT_8.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_CONTENT_8.getKey(), doc.get(FLD_SCHEMA_CONTENT_8.getKey()));
            i++;
        }
        if (doc.get(FLD_SCHEMA_CONTENT_9.getKey()) != null) {
            artifactInfo.getAttributes().put(FLD_SCHEMA_CONTENT_9.getKey(), doc.get(FLD_SCHEMA_CONTENT_9.getKey()));
            i++;
        }

        return i > 0;
    }

    private void updateArtifactInfo(ArtifactInfo ai, File f)
            throws IOException {

        JarFile jar = null;

        try {
            jar = new JarFile(f);

            ZipEntry springSchemasEntry = jar.getEntry("META-INF/spring.schemas");
            if (springSchemasEntry == null) {
                springSchemasEntry = jar.getEntry("classes/META-INF/spring.schemas");
            }
            if (springSchemasEntry == null) {
                return;
            }
            parseSpringSchemas(ai, jar, springSchemasEntry);

            ZipEntry springHandlersEntry = jar.getEntry("META-INF/spring.handlers");
            if (springHandlersEntry == null) {
                springHandlersEntry = jar.getEntry("classes/META-INF/spring.handlers");
            }
            if (springHandlersEntry == null) {
                return;
            }

            parseSpringHandlers(ai, jar, springHandlersEntry);

        } finally {
            if (jar != null) {
                try {
                    jar.close();
                } catch (Exception e) {
                    getLogger().error("Could not close jar file properly.", e);
                }
            }
        }
    }

    private void parseSpringSchemas(ArtifactInfo ai, JarFile jar, ZipEntry springSchemasEntry) throws IOException {
        InputStream springHandlersStream = new BufferedInputStream(jar.getInputStream(springSchemasEntry));
        BufferedReader springSchemasReader = new BufferedReader(new InputStreamReader(springHandlersStream));
        parseSpringSchemasLine(ai, FLD_SCHEMA_LOCATION_0, FLD_SCHEMA_CONTENT_0, jar, springSchemasReader);
        parseSpringSchemasLine(ai, FLD_SCHEMA_LOCATION_1, FLD_SCHEMA_CONTENT_1, jar, springSchemasReader);
        parseSpringSchemasLine(ai, FLD_SCHEMA_LOCATION_2, FLD_SCHEMA_CONTENT_2, jar, springSchemasReader);
        parseSpringSchemasLine(ai, FLD_SCHEMA_LOCATION_3, FLD_SCHEMA_CONTENT_3, jar, springSchemasReader);
        parseSpringSchemasLine(ai, FLD_SCHEMA_LOCATION_4, FLD_SCHEMA_CONTENT_4, jar, springSchemasReader);
        parseSpringSchemasLine(ai, FLD_SCHEMA_LOCATION_5, FLD_SCHEMA_CONTENT_5, jar, springSchemasReader);
        parseSpringSchemasLine(ai, FLD_SCHEMA_LOCATION_6, FLD_SCHEMA_CONTENT_6, jar, springSchemasReader);
        parseSpringSchemasLine(ai, FLD_SCHEMA_LOCATION_7, FLD_SCHEMA_CONTENT_7, jar, springSchemasReader);
        parseSpringSchemasLine(ai, FLD_SCHEMA_LOCATION_8, FLD_SCHEMA_CONTENT_8, jar, springSchemasReader);
        parseSpringSchemasLine(ai, FLD_SCHEMA_LOCATION_9, FLD_SCHEMA_CONTENT_9, jar, springSchemasReader);
        springHandlersStream.close();
    }

    private void parseSpringSchemasLine(ArtifactInfo ai, IndexerField field, IndexerField field2, JarFile jar, BufferedReader springSchemasReader) throws IOException {
        String strLine = springSchemasReader.readLine();
        if (strLine != null) {
            if (strLine.indexOf("=") != -1) {
                String schemaLocation = strLine.substring(0, strLine.indexOf("="));
                String zipFileName = strLine.substring(strLine.indexOf("=") + 1);
                if (schemaLocation != null && schemaLocation.trim().length() > 0) {
                    schemaLocation = schemaLocation.replace("\\:", ":");
                    if (schemaLocation.contains("/current/")) {
                        logger.info("Skipping index of " + ai.groupId + ":" + ai.artifactId + ":" + ai.classifier + ":" + ai.version + " under schema location " + schemaLocation + " because it uses current");
                        return;
                    }
                    logger.info("Indexing " + ai.groupId + ":" + ai.artifactId + ":" + ai.classifier + ":" + ai.version + " under schema location " + schemaLocation);
                    logger.info("Reading schema " + zipFileName + " for schema location " + schemaLocation);
                    ZipEntry schemaEntry = jar.getEntry(zipFileName);
                    if (schemaEntry == null) {
                        schemaEntry = jar.getEntry("classes/" + zipFileName);
                    }
                    if (schemaEntry != null) {
                        String schemaString = readStream(jar.getInputStream(schemaEntry));
                        ai.getAttributes().put(field.getKey(), schemaLocation);
                        ai.getAttributes().put(field2.getKey(), schemaString);
                    } else {
                        logger.error("Cannot find schema " + zipFileName + " inside artifact " + ai.groupId + ":" + ai.artifactId + ":" + ai.classifier + ":" + ai.version);
                    }
                }
            } else {
                logger.error("Cannot parse the following line in spring.schemas: " + strLine);
            }
        }
    }

    private void parseSpringHandlers(ArtifactInfo ai, JarFile jar, ZipEntry springHandlersEntry) throws IOException {
        InputStream springSchemasStream = new BufferedInputStream(jar.getInputStream(springHandlersEntry));
        BufferedReader springSchemasReader = new BufferedReader(new InputStreamReader(springSchemasStream));
        parseSpringHandlersLine(ai, FLD_SCHEMA_NAMESPACE_0, springSchemasReader);
        parseSpringHandlersLine(ai, FLD_SCHEMA_NAMESPACE_1, springSchemasReader);
        parseSpringHandlersLine(ai, FLD_SCHEMA_NAMESPACE_2, springSchemasReader);
        parseSpringHandlersLine(ai, FLD_SCHEMA_NAMESPACE_3, springSchemasReader);
        parseSpringHandlersLine(ai, FLD_SCHEMA_NAMESPACE_4, springSchemasReader);
        parseSpringHandlersLine(ai, FLD_SCHEMA_NAMESPACE_5, springSchemasReader);
        parseSpringHandlersLine(ai, FLD_SCHEMA_NAMESPACE_6, springSchemasReader);
        parseSpringHandlersLine(ai, FLD_SCHEMA_NAMESPACE_7, springSchemasReader);
        parseSpringHandlersLine(ai, FLD_SCHEMA_NAMESPACE_8, springSchemasReader);
        parseSpringHandlersLine(ai, FLD_SCHEMA_NAMESPACE_9, springSchemasReader);
        springSchemasStream.close();
    }

    private void parseSpringHandlersLine(ArtifactInfo ai, IndexerField field, BufferedReader springSchemasReader) throws IOException {
        String strLine = springSchemasReader.readLine();
        if (strLine != null) {
            if (strLine.indexOf("=") != -1) {
                String schemaNamespace = strLine.substring(0, strLine.indexOf("="));
                schemaNamespace = schemaNamespace.replace("\\:", ":");
                if (schemaNamespace != null && schemaNamespace.trim().length() > 0) {
                    if (!(ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_0.getKey()) &&
                            ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_0.getKey()).equals(schemaNamespace)) &&
                            !(ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_1.getKey()) &&
                                    ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_1.getKey()).equals(schemaNamespace)) &&
                            !(ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_2.getKey()) &&
                                    ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_2.getKey()).equals(schemaNamespace)) &&
                            !(ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_3.getKey()) &&
                                    ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_3.getKey()).equals(schemaNamespace)) &&
                            !(ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_4.getKey()) &&
                                    ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_4.getKey()).equals(schemaNamespace)) &&
                            !(ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_5.getKey()) &&
                                    ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_5.getKey()).equals(schemaNamespace)) &&
                            !(ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_6.getKey()) &&
                                    ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_6.getKey()).equals(schemaNamespace)) &&
                            !(ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_7.getKey()) &&
                                    ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_7.getKey()).equals(schemaNamespace)) &&
                            !(ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_8.getKey()) &&
                                    ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_8.getKey()).equals(schemaNamespace)) &&
                            !(ai.getAttributes().containsKey(FLD_SCHEMA_NAMESPACE_9.getKey()) &&
                                    ai.getAttributes().get(FLD_SCHEMA_NAMESPACE_9.getKey()).equals(schemaNamespace))) {
                        logger.info("Indexing " + ai.groupId + ":" + ai.artifactId + ":" + ai.classifier + ":" + ai.version + " under namespace " + schemaNamespace);
                        ai.getAttributes().put(field.getKey(), schemaNamespace);
                    }
                }
            } else {
                logger.error("Cannot parse the following line in spring.handlers: " + strLine);
            }
        }
    }

    private String readStream(InputStream is) throws IOException {
        final char[] buffer = new char[0x10000];
        StringBuilder out = new StringBuilder();
        Reader in = new InputStreamReader(is, "UTF-8");
        try {
            int read;
            do {
                read = in.read(buffer, 0, buffer.length);
                if (read > 0) {
                    out.append(buffer, 0, read);
                }
            } while (read >= 0);
        } finally {
            in.close();
        }
        return out.toString();
    }

    @Override
    public String toString() {
        return ID;
    }

    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_SCHEMA_VERSION,
                FLD_SCHEMA_NAMESPACE_0,
                FLD_SCHEMA_NAMESPACE_1,
                FLD_SCHEMA_NAMESPACE_2,
                FLD_SCHEMA_NAMESPACE_3,
                FLD_SCHEMA_NAMESPACE_4,
                FLD_SCHEMA_NAMESPACE_5,
                FLD_SCHEMA_NAMESPACE_6,
                FLD_SCHEMA_NAMESPACE_7,
                FLD_SCHEMA_NAMESPACE_8,
                FLD_SCHEMA_NAMESPACE_9,
                FLD_SCHEMA_LOCATION_0,
                FLD_SCHEMA_LOCATION_1,
                FLD_SCHEMA_LOCATION_2,
                FLD_SCHEMA_LOCATION_3,
                FLD_SCHEMA_LOCATION_4,
                FLD_SCHEMA_LOCATION_5,
                FLD_SCHEMA_LOCATION_6,
                FLD_SCHEMA_LOCATION_7,
                FLD_SCHEMA_LOCATION_8,
                FLD_SCHEMA_LOCATION_9,
                FLD_SCHEMA_CONTENT_0,
                FLD_SCHEMA_CONTENT_1,
                FLD_SCHEMA_CONTENT_2,
                FLD_SCHEMA_CONTENT_3,
                FLD_SCHEMA_CONTENT_4,
                FLD_SCHEMA_CONTENT_5,
                FLD_SCHEMA_CONTENT_6,
                FLD_SCHEMA_CONTENT_7,
                FLD_SCHEMA_CONTENT_8,
                FLD_SCHEMA_CONTENT_9);
    }
}