package org.mule.devkit.nexus;

import com.noelios.restlet.http.HttpRequest;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.Field;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.index.DefaultIndexerManager;
import org.sonatype.nexus.index.IndexerManager;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;

import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import java.io.IOException;

@Component(role = PlexusResource.class, hint = "ModuleSchemaResource")
@Path(ModuleSchemaResource.MODULE_SCHEMA_URI)
@Produces({"application/xml", "application/json"})
public class ModuleSchemaResource extends AbstractNexusPlexusResource implements LogEnabled {

    public static final String MODULE_SCHEMA_URI = "/schema";

    @Inject
    private NexusIndexer nexusIndexer;
    
    @Inject
    private IndexerManager indexerManager;

    @Inject
    @Named("maven2")
    private ContentClass maven2ContentClass;

    private Logger logger;

    @Override
    public String getResourceUri() {
        return MODULE_SCHEMA_URI;
    }

    @Override
    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(getResourceUri(), "anon");
    }

    @Override
    public Object getPayloadInstance() {
        return null;
    }

    public void enableLogging(final Logger logger) {
        this.logger = logger;
    }

    @Override
    @GET
    public Object get(Context context, Request request, Response response, Variant variant)
            throws ResourceException {
        String targetSchemaLocation = ((HttpRequest) request).getHttpCall().getRequestUri().replace("/nexus/service/local" + MODULE_SCHEMA_URI, "http://www.mulesoft.org/schema");

        for (Repository repository : getUnprotectedRepositoryRegistry().getRepositories()) {
            if (maven2ContentClass.isCompatible(repository.getRepositoryContentClass())
                    && repository.getRepositoryKind().isFacetAvailable(HostedRepository.class)) {

                logger.info("Searching for schema location " + targetSchemaLocation + " under repository " + repository.getId());

                if (searchSchemaLocation(response, repository, Module.SCHEMA_LOCATION_0, ModuleIndexCreator.FLD_SCHEMA_CONTENT_0, targetSchemaLocation)) {
                    return response.getEntity();
                } else if (searchSchemaLocation(response, repository, Module.SCHEMA_LOCATION_1, ModuleIndexCreator.FLD_SCHEMA_CONTENT_1, targetSchemaLocation)) {
                    return response.getEntity();
                } else if (searchSchemaLocation(response, repository, Module.SCHEMA_LOCATION_2, ModuleIndexCreator.FLD_SCHEMA_CONTENT_2, targetSchemaLocation)) {
                    return response.getEntity();
                } else if (searchSchemaLocation(response, repository, Module.SCHEMA_LOCATION_3, ModuleIndexCreator.FLD_SCHEMA_CONTENT_3, targetSchemaLocation)) {
                    return response.getEntity();
                } else if (searchSchemaLocation(response, repository, Module.SCHEMA_LOCATION_4, ModuleIndexCreator.FLD_SCHEMA_CONTENT_4, targetSchemaLocation)) {
                    return response.getEntity();
                } else if (searchSchemaLocation(response, repository, Module.SCHEMA_LOCATION_5, ModuleIndexCreator.FLD_SCHEMA_CONTENT_5, targetSchemaLocation)) {
                    return response.getEntity();
                } else if (searchSchemaLocation(response, repository, Module.SCHEMA_LOCATION_6, ModuleIndexCreator.FLD_SCHEMA_CONTENT_6, targetSchemaLocation)) {
                    return response.getEntity();
                } else if (searchSchemaLocation(response, repository, Module.SCHEMA_LOCATION_7, ModuleIndexCreator.FLD_SCHEMA_CONTENT_7, targetSchemaLocation)) {
                    return response.getEntity();
                } else if (searchSchemaLocation(response, repository, Module.SCHEMA_LOCATION_8, ModuleIndexCreator.FLD_SCHEMA_CONTENT_8, targetSchemaLocation)) {
                    return response.getEntity();
                } else if (searchSchemaLocation(response, repository, Module.SCHEMA_LOCATION_9, ModuleIndexCreator.FLD_SCHEMA_CONTENT_9, targetSchemaLocation)) {
                    return response.getEntity();
                }
            }
        }

        response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        return null;
    }

    private boolean searchSchemaLocation(Response response, Repository repository, Field schemaLocationField, IndexerField schemaContentField, String targetSchemaLocation) {
        Query pq = nexusIndexer.constructQuery(schemaLocationField, targetSchemaLocation, SearchType.EXACT);
        IndexingContext indexingContext = ((DefaultIndexerManager) indexerManager).getRepositoryIndexContext(repository);

        IteratorSearchRequest sreq = new IteratorSearchRequest(pq, indexingContext);

        IteratorSearchResponse hits = null;

        try {
            hits = nexusIndexer.searchIterator(sreq);
            for (ArtifactInfo info : hits) {
                if (info.classifier == null) {
                    logger.info("Found artifact " + info.groupId + ":" + info.artifactId + ":" + info.classifier + ":" + info.version + " that provides the specified schema location");
                    if (info.getAttributes().get(schemaContentField.getKey()) != null) {
                        response.setEntity(info.getAttributes().get(schemaContentField.getKey()), MediaType.APPLICATION_XML);
                        response.setStatus(Status.SUCCESS_OK);
                        return true;
                    }
                }
            }
        } catch (IOException e) {
            logger.error("INTERNAL ERROR: " + e.getMessage(), e);
        } finally {
            if(hits != null) {
                try {
                    hits.close();
                } catch(IOException e) {
                    logger.error("INTERNAL ERROR: " + e.getMessage(), e);
                }
            }
        }
        return false;
    }
}
