/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.nexus;

import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.events.EventInspector;
import org.sonatype.nexus.proxy.events.RepositoryEventLocalStatusChanged;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.events.RepositoryRegistryRepositoryEvent;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.plexus.appevents.Event;

public class ModuleCatalogEventInspector
implements EventInspector {
    private static final String ARCHETYPE_PATH = "/module-catalog.xml";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="maven2")
    private ContentClass maven2ContentClass;

    public boolean accepts(Event<?> evt) {
        if (evt instanceof RepositoryRegistryEventAdd) {
            RepositoryRegistryRepositoryEvent registryEvent = (RepositoryRegistryRepositoryEvent)evt;
            Repository repository = registryEvent.getRepository();
            return this.maven2ContentClass.isCompatible(repository.getRepositoryContentClass()) && (repository.getRepositoryKind().isFacetAvailable(HostedRepository.class) || repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class) || repository.getRepositoryKind().isFacetAvailable(GroupRepository.class));
        }
        if (evt instanceof RepositoryEventLocalStatusChanged) {
            RepositoryEventLocalStatusChanged localStatusEvent = (RepositoryEventLocalStatusChanged)evt;
            return LocalStatus.IN_SERVICE.equals((Object)localStatusEvent.getNewLocalStatus());
        }
        return false;
    }

    public void inspect(Event<?> evt) {
        Repository repository = null;
        if (evt instanceof RepositoryRegistryEventAdd) {
            RepositoryRegistryRepositoryEvent registryEvent = (RepositoryRegistryRepositoryEvent)evt;
            repository = registryEvent.getRepository();
        } else if (evt instanceof RepositoryEventLocalStatusChanged) {
            RepositoryEventLocalStatusChanged localStatusEvent = (RepositoryEventLocalStatusChanged)evt;
            repository = localStatusEvent.getRepository();
        } else {
            return;
        }
        if (this.maven2ContentClass.isCompatible(repository.getRepositoryContentClass()) && (repository.getRepositoryKind().isFacetAvailable(HostedRepository.class) || repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class) || repository.getRepositoryKind().isFacetAvailable(GroupRepository.class))) {
            try {
                DefaultStorageFileItem file = new DefaultStorageFileItem(repository, new ResourceStoreRequest(ARCHETYPE_PATH), true, false, (ContentLocator)new StringContentLocator("mule-module-catalog-content-generator"));
                file.setContentGeneratorId("mule-module-catalog-content-generator");
                repository.storeItem(false, (StorageItem)file);
            }
            catch (RepositoryNotAvailableException e) {
                this.logger.info("Unable to install the generated module catalog, repository \"" + e.getRepository().getId() + "\" is out of service.");
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Unable to install the generated module catalog!", (Throwable)e);
                }
                this.logger.info("Unable to install the generated module catalog:" + e.getMessage());
            }
        }
    }
}

