/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.meta;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.Registry;
import org.mule.devkit.model.meta.MetaModule;
import org.mule.devkit.model.meta.MetaRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModel
implements Initialisable,
Disposable {
    private static Logger logger = LoggerFactory.getLogger(MetaModel.class);
    private static final String SPRING_SCHEMAS_LOCATION = "META-INF/spring.schemas";
    private Map<String, MetaModule> modules = new HashMap<String, MetaModule>();
    private MuleContext muleContext;
    private Registry metaRegistry;

    public MetaModel(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected void finalize() {
        if (this.muleContext != null) {
            this.muleContext.removeRegistry(this.metaRegistry);
        }
    }

    public void addModule(MetaModule module) {
        this.modules.put(module.getNamespace(), module);
    }

    public void removeModule(String name) {
        this.modules.remove(name);
    }

    public MetaModule getModule(String namespace) {
        if (!this.modules.containsKey(namespace)) {
            throw new IllegalArgumentException("Unable to find a module for namespace " + namespace);
        }
        return this.modules.get(namespace);
    }

    public Registry getMetaRegistry() {
        return this.metaRegistry;
    }

    private static synchronized Map<String, String> getSchemas(ClassLoader classLoader) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading schema mappings from [META-INF/spring.schemas]");
        }
        try {
            Properties mappings = PropertiesLoaderUtils.loadAllProperties((String)SPRING_SCHEMAS_LOCATION, (ClassLoader)classLoader);
            if (logger.isDebugEnabled()) {
                logger.debug("Loaded schema mappings: " + mappings);
            }
            ConcurrentHashMap<String, String> schemaMappings = new ConcurrentHashMap<String, String>();
            CollectionUtils.mergePropertiesIntoMap((Properties)mappings, schemaMappings);
            return schemaMappings;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load schema mappings from location [META-INF/spring.schemas]", ex);
        }
    }

    public synchronized void dispose() {
        if (this.metaRegistry != null) {
            this.metaRegistry.dispose();
            this.muleContext.removeRegistry(this.metaRegistry);
        }
        this.metaRegistry = null;
    }

    public synchronized void initialise() throws InitialisationException {
        Map<String, String> schemas = MetaModel.getSchemas(this.muleContext.getExecutionClassLoader());
        for (String name : schemas.keySet()) {
            ClassPathResource resource = new ClassPathResource(schemas.get(name), this.muleContext.getExecutionClassLoader());
            MetaModule metaModule = null;
            try {
                metaModule = MetaModule.parseSchema(this, resource.getInputStream());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (metaModule == null) continue;
            this.addModule(metaModule);
        }
        this.metaRegistry = new MetaRegistry(this.muleContext);
        this.muleContext.addRegistry(this.metaRegistry);
        this.metaRegistry.initialise();
    }
}

