/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.mule.devkit.maven.AbstractMuleMojo;
import org.mule.devkit.maven.ArtifactFilter;
import org.mule.devkit.maven.Exclusion;
import org.mule.devkit.maven.Inclusion;
import org.mule.devkit.maven.ModuleArchiver;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PackageMojo
extends AbstractMuleMojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(alias="${archiveClasses}", property="archiveClasses", defaultValue="false")
    private boolean archiveClasses;
    @Parameter
    private List<Exclusion> exclusions;
    @Parameter
    private List<Inclusion> inclusions;
    @Parameter(defaultValue="true")
    private boolean excludeMuleDependencies;
    @Parameter(defaultValue="false")
    private boolean filterAppDirectory;
    @Parameter(alias="${attachShadedJar}", property="attachShadedJar", defaultValue="true")
    private boolean attachShadedJar;
    @Parameter(alias="${attachConnectorLibs}", property="attachConnectorLibs", defaultValue="true")
    private boolean attachConnectorLibs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File plugin = this.getMuleZipFile();
        try {
            this.createMulePlugin(plugin);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule Plugin", (Exception)((Object)e));
        }
        this.projectHelper.attachArtifact(this.project, "zip", "plugin", plugin);
    }

    protected void createMulePlugin(File plugin) throws MojoExecutionException, ArchiverException {
        ModuleArchiver archiver = new ModuleArchiver();
        this.addAppDirectory(archiver);
        this.addCompiledClasses(archiver);
        this.addDependencies(archiver);
        archiver.setDestFile(plugin);
        try {
            plugin.delete();
            archiver.createArchive();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot create archive", (Throwable)e);
        }
    }

    private void addAppDirectory(ModuleArchiver archiver) throws ArchiverException {
        if (this.filterAppDirectory) {
            if (this.getFilteredAppDirectory().exists()) {
                archiver.addResources(this.getFilteredAppDirectory());
            }
        } else if (this.appDirectory.exists()) {
            archiver.addResources(this.appDirectory);
        }
    }

    private void addCompiledClasses(ModuleArchiver archiver) throws ArchiverException, MojoExecutionException {
        if (this.attachShadedJar && this.isShadingActive(this.project)) {
            this.addConnectorJar(archiver);
            return;
        }
        if (!this.archiveClasses) {
            this.addClassesFolder(archiver);
        } else {
            this.addArchivedClasses(archiver);
        }
    }

    private boolean isShadingActive(MavenProject project) {
        return project != null && project.getBuild() != null && project.getBuild().getPluginsAsMap() != null && project.getBuild().getPluginsAsMap().containsKey("org.apache.maven.plugins:maven-shade-plugin");
    }

    private void addConnectorJar(ModuleArchiver archiver) throws MojoExecutionException {
        File jar = new File(this.outputDirectory, this.finalName + ".jar");
        if (jar.exists()) {
            archiver.addLib(jar);
        }
    }

    private void addClassesFolder(ModuleArchiver archiver) throws ArchiverException {
        if (this.classesDirectory.exists()) {
            this.getLog().info((CharSequence)"Copying classes directly");
            archiver.addClasses(this.classesDirectory, null, null);
        } else {
            this.getLog().info((CharSequence)(this.classesDirectory + " does not exist, skipping"));
        }
    }

    private void addArchivedClasses(ModuleArchiver archiver) throws ArchiverException, MojoExecutionException {
        if (!this.classesDirectory.exists()) {
            this.getLog().info((CharSequence)(this.classesDirectory + " does not exist, skipping"));
            return;
        }
        this.getLog().info((CharSequence)"Copying classes as a jar");
        JarArchiver jarArchiver = new JarArchiver();
        jarArchiver.addDirectory(this.classesDirectory, null, null);
        File jar = new File(this.outputDirectory, this.finalName + ".jar");
        jarArchiver.setDestFile(jar);
        try {
            jarArchiver.createArchive();
            archiver.addLib(jar);
        }
        catch (IOException e) {
            String message = "Cannot create project jar";
            this.getLog().error((CharSequence)"Cannot create project jar", (Throwable)e);
            throw new MojoExecutionException("Cannot create project jar", (Exception)e);
        }
    }

    private void addDependencies(ModuleArchiver archiver) throws ArchiverException {
        if (!this.attachConnectorLibs && this.isShadingActive(this.project)) {
            return;
        }
        for (Artifact artifact : this.getArtifactsToArchive()) {
            String message = String.format("Adding <%1s> as a lib", artifact.getId());
            this.getLog().info((CharSequence)message);
            archiver.addLib(artifact.getFile());
        }
    }

    private Set<Artifact> getArtifactsToArchive() {
        ArtifactFilter filter = new ArtifactFilter(this.project, this.inclusions, this.exclusions, this.excludeMuleDependencies);
        return filter.getArtifactsToArchive();
    }
}

