/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.io.File;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;

public class ModuleArchiver
extends ZipArchiver {
    public static final String LIB_LOCATION = "lib/";
    public static final String CLASSES_LOCATION = "classes/";
    public static final String PLUGINS_LOCATION = "plugins/";
    public static final String ROOT_LOCATION = "";

    public void addResources(File directoryName) throws ArchiverException {
        this.addDirectory(directoryName, ROOT_LOCATION, null, this.addDefaultExcludes(null));
    }

    public void addLib(File file) throws ArchiverException {
        this.addFile(file, LIB_LOCATION + file.getName());
    }

    public void addLibs(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, LIB_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addPlugin(File plugin) throws ArchiverException {
        this.addFile(plugin, PLUGINS_LOCATION + plugin.getName());
    }

    public void addClasses(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, CLASSES_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    private String[] addDefaultExcludes(String[] excludes) {
        if (excludes == null || excludes.length == 0) {
            return DirectoryScanner.DEFAULTEXCLUDES;
        }
        String[] newExcludes = new String[excludes.length + DirectoryScanner.DEFAULTEXCLUDES.length];
        System.arraycopy(DirectoryScanner.DEFAULTEXCLUDES, 0, newExcludes, 0, DirectoryScanner.DEFAULTEXCLUDES.length);
        System.arraycopy(excludes, 0, newExcludes, DirectoryScanner.DEFAULTEXCLUDES.length, excludes.length);
        return newExcludes;
    }
}

