/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.eclipse.egit.github.core.RepositoryId;

public class RepositoryUtils {
    public static RepositoryId extractRepositoryFromScmUrl(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        int ghIndex = url.indexOf("github.com");
        if (ghIndex == -1 || ghIndex + 1 >= url.length()) {
            return null;
        }
        if (!url.endsWith(".git")) {
            return null;
        }
        url = url.substring(ghIndex + "github.com".length() + 1, url.length() - ".git".length());
        return RepositoryId.createFromId((String)url);
    }

    public static RepositoryId getRepository(MavenProject project, String owner, String name) {
        if (!StringUtils.isEmpty((String)owner) && !StringUtils.isEmpty((String)name)) {
            return RepositoryId.create((String)owner, (String)name);
        }
        if (project == null) {
            return null;
        }
        RepositoryId repo = null;
        Scm scm = project.getScm();
        if (scm == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)scm.getUrl())) {
            repo = RepositoryId.createFromUrl((String)scm.getUrl());
        }
        if (repo == null) {
            repo = RepositoryUtils.extractRepositoryFromScmUrl(scm.getConnection());
        }
        if (repo == null) {
            repo = RepositoryUtils.extractRepositoryFromScmUrl(scm.getDeveloperConnection());
        }
        return repo;
    }
}

